/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.Listener;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.bridge.ConnectionBridgeServer;
import dorkbox.network.connection.bridge.ConnectionExceptSpecifiedBridgeServer;
import dorkbox.network.connection.listenerManagement.OnConnectedManager;
import dorkbox.network.connection.listenerManagement.OnDisconnectedManager;
import dorkbox.network.connection.listenerManagement.OnIdleManager;
import dorkbox.network.connection.listenerManagement.OnMessageReceivedManager;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.util.Property;
import dorkbox.util.collections.ConcurrentEntry;
import dorkbox.util.generics.ClassHelper;
import dorkbox.util.generics.TypeResolver;
import io.netty.bootstrap.DatagramCloseMessage;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager<C extends Connection>
implements Listeners,
ISessionManager,
ConnectionPoint,
ConnectionBridgeServer,
ConnectionExceptSpecifiedBridgeServer {
    @Property
    public static final float LOAD_FACTOR = 0.8f;
    private static final AtomicReferenceFieldUpdater<ConnectionManager, IdentityMap> localManagersREF = AtomicReferenceFieldUpdater.newUpdater(ConnectionManager.class, IdentityMap.class, "localManagers");
    private static final AtomicReferenceFieldUpdater<ConnectionManager, ConcurrentEntry> connectionsREF = AtomicReferenceFieldUpdater.newUpdater(ConnectionManager.class, ConcurrentEntry.class, "connectionsHead");
    private final String loggerName;
    private final OnConnectedManager<C> onConnectedManager;
    private final OnDisconnectedManager<C> onDisconnectedManager;
    private final OnIdleManager<C> onIdleManager;
    private final OnMessageReceivedManager<C> onMessageReceivedManager;
    private volatile ConcurrentEntry<Connection> connectionsHead = null;
    private final IdentityMap<Connection, ConcurrentEntry> connectionEntries = new IdentityMap(32, 0.8f);
    private volatile IdentityMap<Connection, ConnectionManager> localManagers = new IdentityMap(8, 0.8f);
    private final Object singleWriterConnectionsLock = new Object();
    private final Object singleWriterLocalManagerLock = new Object();
    private final Class<?> baseClass;
    protected final Logger logger;
    private final AtomicBoolean hasAtLeastOneListener = new AtomicBoolean(false);
    final AtomicBoolean shutdown = new AtomicBoolean(false);

    ConnectionManager(String loggerName, Class<?> baseClass) {
        this.loggerName = loggerName;
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.baseClass = baseClass;
        this.onConnectedManager = new OnConnectedManager(this.logger);
        this.onDisconnectedManager = new OnDisconnectedManager(this.logger);
        this.onIdleManager = new OnIdleManager(this.logger);
        this.onMessageReceivedManager = new OnMessageReceivedManager(this.logger);
    }

    @Override
    public final Listeners add(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Class<?> genericClass = ClassHelper.getGenericParameterAsClassForSuperClass(Listener.class, listener.getClass(), 0);
        if (genericClass == this.baseClass || genericClass == TypeResolver.Unknown.class || genericClass == null) {
            this.addListener0(listener);
            return this;
        }
        if (ClassHelper.hasInterface(Connection.class, genericClass) && !ClassHelper.hasParentClass(this.baseClass, genericClass)) {
            this.addListener0(listener);
            return this;
        }
        throw new IllegalArgumentException("Unable to add incompatible connection type as a listener! : " + this.baseClass);
    }

    private void addListener0(Listener listener) {
        boolean found = false;
        if (listener instanceof Listener.OnConnected) {
            this.onConnectedManager.add((Listener.OnConnected)listener);
            found = true;
        }
        if (listener instanceof Listener.OnDisconnected) {
            this.onDisconnectedManager.add((Listener.OnDisconnected)listener);
            found = true;
        }
        if (listener instanceof Listener.OnIdle) {
            this.onIdleManager.add((Listener.OnIdle)listener);
            found = true;
        }
        if (listener instanceof Listener.OnMessageReceived) {
            this.onMessageReceivedManager.add((Listener.OnMessageReceived)listener);
            found = true;
        }
        if (found) {
            this.hasAtLeastOneListener.set(true);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("listener added: {}", (Object)listener.getClass().getName());
            }
        } else {
            this.logger.error("No matching listener types. Unable to add listener: {}", (Object)listener.getClass().getName());
        }
    }

    @Override
    public final Listeners remove(Listener listener) {
        int size;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("listener removed: {}", (Object)listener.getClass().getName());
        }
        boolean found = false;
        int remainingListeners = 0;
        if (listener instanceof Listener.OnConnected && (size = this.onConnectedManager.removeWithSize((Listener.OnConnected)listener)) >= 0) {
            remainingListeners += size;
            found = true;
        }
        if (listener instanceof Listener.OnDisconnected && (size = this.onDisconnectedManager.removeWithSize((Listener.OnDisconnected)listener)) >= 0) {
            remainingListeners += size;
            found |= true;
        }
        if (listener instanceof Listener.OnIdle && (size = this.onIdleManager.removeWithSize((Listener.OnIdle)listener)) >= 0) {
            remainingListeners += size;
            found |= true;
        }
        if (listener instanceof Listener.OnMessageReceived && (size = this.onMessageReceivedManager.removeWithSize((Listener.OnMessageReceived)listener)) >= 0) {
            remainingListeners += size;
            found |= true;
        }
        if (found) {
            if (remainingListeners == 0) {
                this.hasAtLeastOneListener.set(false);
            }
        } else {
            this.logger.error("No matching listener types. Unable to remove listener: {}", (Object)listener.getClass().getName());
        }
        return this;
    }

    @Override
    public final Listeners removeAll() {
        this.onConnectedManager.clear();
        this.onDisconnectedManager.clear();
        this.onIdleManager.clear();
        this.onMessageReceivedManager.clear();
        this.logger.trace("ALL listeners removed !!");
        return this;
    }

    @Override
    public final Listeners removeAll(Class<?> classType) {
        if (classType == null) {
            throw new IllegalArgumentException("classType cannot be null.");
        }
        Logger logger2 = this.logger;
        if (this.onMessageReceivedManager.removeAll(classType)) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("All listeners removed for type: {}", (Object)classType.getClass().getName());
            }
        } else {
            logger2.warn("No listeners found to remove for type: {}", (Object)classType.getClass().getName());
        }
        return this;
    }

    @Override
    public final void onMessage(ConnectionImpl connection, Object message) {
        Class<?> messageClass = message.getClass();
        if (messageClass == PingMessage.class) {
            PingMessage ping = (PingMessage)message;
            if (ping.isReply) {
                connection.updatePingResponse(ping);
            } else {
                ping.isReply = true;
                connection.ping0(ping);
            }
        } else if (messageClass == DatagramCloseMessage.class) {
            connection.forceClose();
        } else {
            this.notifyOnMessage0(connection, message, false);
        }
    }

    private boolean notifyOnMessage0(ConnectionImpl connection, Object message, boolean foundListener) {
        if (connection.manageRmi(message)) {
            connection.flush();
            return true;
        }
        message = connection.fixupRmi(message);
        foundListener |= this.onMessageReceivedManager.notifyReceived(connection, message, this.shutdown);
        IdentityMap localManagers = localManagersREF.get(this);
        ConnectionManager localManager = (ConnectionManager)localManagers.get((Object)connection);
        if (localManager != null) {
            foundListener |= localManager.notifyOnMessage0(connection, message, foundListener);
        }
        if (foundListener) {
            connection.flush();
        } else {
            this.logger.warn("----------- LISTENER NOT REGISTERED FOR TYPE: {}", (Object)message.getClass().getSimpleName());
        }
        return foundListener;
    }

    @Override
    public final void onIdle(ConnectionImpl connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        boolean foundListener = this.onIdleManager.notifyIdle(connection, this.shutdown);
        if (foundListener) {
            connection.flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get((Object)connection)) != null) {
            localManager.onIdle(connection);
        }
    }

    @Override
    public void onConnected(ConnectionImpl connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        boolean foundListener = this.onConnectedManager.notifyConnected(connection, this.shutdown);
        if (foundListener) {
            connection.flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get((Object)connection)) != null) {
            localManager.onConnected(connection);
        }
    }

    @Override
    public void onDisconnected(ConnectionImpl connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        this.logger.trace("onDisconnected({})", (Object)connection.id());
        boolean foundListener = this.onDisconnectedManager.notifyDisconnected(connection);
        if (foundListener) {
            connection.flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get((Object)connection)) != null) {
            localManager.onDisconnected(connection);
            this.removeListenerManager(connection);
        }
        this.removeConnection(connection);
    }

    @Override
    public void addConnection(ConnectionImpl connection) {
        this.addConnection0(connection);
        IdentityMap localManagers = localManagersREF.get(this);
        ConnectionManager localManager = (ConnectionManager)localManagers.get((Object)connection);
        if (localManager != null) {
            localManager.addConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection0(Connection connection) {
        Object object = this.singleWriterConnectionsLock;
        synchronized (object) {
            ConcurrentEntry<Connection> head = connectionsREF.get(this);
            if (!this.connectionEntries.containsKey((Object)connection)) {
                head = new ConcurrentEntry<Connection>(connection, head);
                this.connectionEntries.put((Object)connection, head);
                connectionsREF.lazySet(this, head);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(Connection connection) {
        Object object = this.singleWriterConnectionsLock;
        synchronized (object) {
            ConcurrentEntry concurrentEntry = (ConcurrentEntry)this.connectionEntries.get((Object)connection);
            if (concurrentEntry != null) {
                ConcurrentEntry head1 = connectionsREF.get(this);
                if (concurrentEntry == head1) {
                    head1 = head1.next();
                } else {
                    concurrentEntry.remove();
                }
                connectionsREF.lazySet(this, head1);
                this.connectionEntries.remove((Object)connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<C> getConnections() {
        Object object = this.singleWriterConnectionsLock;
        synchronized (object) {
            IdentityMap.Keys keys = this.connectionEntries.keys();
            return keys.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ConnectionManager addListenerManager(Connection connection) {
        Logger logger2;
        ConnectionManager<C> manager;
        boolean created = false;
        Object object = this.singleWriterLocalManagerLock;
        synchronized (object) {
            IdentityMap localManagers = localManagersREF.get(this);
            manager = (ConnectionManager<C>)localManagers.get((Object)connection);
            if (manager == null) {
                created = true;
                manager = new ConnectionManager<C>(this.loggerName + "-" + connection.toString() + " Specific", this.baseClass);
                localManagers.put((Object)connection, manager);
                localManagersREF.lazySet(this, localManagers);
            }
        }
        if (created && (logger2 = this.logger).isTraceEnabled()) {
            logger2.trace("Connection specific Listener Manager added for connection: {}", (Object)connection);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeListenerManager(Connection connection) {
        Logger logger2;
        boolean wasRemoved = false;
        Object object = this.singleWriterLocalManagerLock;
        synchronized (object) {
            IdentityMap localManagers = localManagersREF.get(this);
            ConnectionManager removed = (ConnectionManager)localManagers.remove((Object)connection);
            if (removed != null) {
                wasRemoved = true;
                localManagersREF.lazySet(this, localManagers);
            }
        }
        if (wasRemoved && (logger2 = this.logger).isTraceEnabled()) {
            logger2.trace("Connection specific Listener Manager removed for connection: {}", (Object)connection);
        }
    }

    final boolean hasListeners() {
        return this.hasAtLeastOneListener.get();
    }

    final void stop() {
        this.shutdown.set(true);
        this.closeConnections(false);
        this.onConnectedManager.clear();
        this.onDisconnectedManager.clear();
        this.onIdleManager.clear();
        this.onMessageReceivedManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeConnections(boolean keepListeners) {
        LinkedList<ConnectionImpl> closeConnections = new LinkedList<ConnectionImpl>();
        Iterator iterator = this.singleWriterConnectionsLock;
        synchronized (iterator) {
            IdentityMap.Keys keys = this.connectionEntries.keys();
            for (Connection connection : keys) {
                if (!(connection instanceof ConnectionImpl)) continue;
                closeConnections.add((ConnectionImpl)connection);
            }
            this.connectionEntries.clear();
            this.connectionsHead = null;
        }
        for (ConnectionImpl connection : closeConnections) {
            connection.close(keepListeners);
        }
    }

    @Override
    public boolean isWritable() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void write(Object object) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public ConnectionExceptSpecifiedBridgeServer except() {
        return this;
    }

    @Override
    public <V> Promise<V> newPromise() {
        return ImmediateEventExecutor.INSTANCE.newPromise();
    }

    @Override
    public ConnectionPoint TCP(Connection connection, Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            if (c == connection) continue;
            c.send().TCP(message);
        }
        return this;
    }

    @Override
    public ConnectionPoint UDP(Connection connection, Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            if (c == connection) continue;
            c.send().UDP(message);
        }
        return this;
    }

    @Override
    public ConnectionPoint self(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            ConnectionImpl c = (ConnectionImpl)current.getValue();
            this.onMessage(c, message);
        }
        return this;
    }

    @Override
    public ConnectionPoint TCP(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send().TCP(message);
        }
        return this;
    }

    @Override
    public ConnectionPoint UDP(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send().UDP(message);
        }
        return this;
    }

    protected ConnectionPoint send(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send(message);
        }
        return this;
    }

    @Override
    public void flush() {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            ConnectionImpl c = (ConnectionImpl)current.getValue();
            c.flush();
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return 0;
    }
}

