/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.Configuration;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionManager;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.PropertyStore;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.Shutdownable;
import dorkbox.network.connection.bridge.ConnectionBridgeBase;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelLocalWrapper;
import dorkbox.network.connection.wrapper.ChannelNetworkWrapper;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.rmi.RmiBridge;
import dorkbox.network.rmi.RmiObjectHandler;
import dorkbox.network.rmi.RmiObjectLocalHandler;
import dorkbox.network.rmi.RmiObjectNetworkHandler;
import dorkbox.network.serialization.CryptoSerializationManager;
import dorkbox.network.serialization.Serialization;
import dorkbox.network.store.NullSettingsStore;
import dorkbox.network.store.SettingsStore;
import dorkbox.util.Property;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.entropy.Entropy;
import dorkbox.util.exceptions.SecurityException;
import io.netty.channel.local.LocalAddress;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EndPoint
extends Shutdownable {
    @Property
    public static boolean enableNativeLibrary = false;
    public static final String LOCAL_CHANNEL = "local_channel";
    @Property
    public static int udpMaxSize = 508;
    protected final ConnectionManager connectionManager;
    protected final CryptoSerializationManager serializationManager;
    protected final RegistrationWrapper registrationWrapper;
    final ECPrivateKeyParameters privateKey;
    final ECPublicKeyParameters publicKey;
    final SecureRandom secureRandom;
    private final RmiObjectHandler rmiHandler;
    private final RmiObjectLocalHandler localRmiHandler;
    private final RmiObjectNetworkHandler networkRmiHandler;
    final RmiBridge globalRmiBridge;
    private final Executor rmiExecutor;
    private final boolean rmiEnabled;
    SettingsStore propertyStore;
    boolean disableRemoteKeyValidation;
    private volatile int idleTimeoutMs = 0;
    protected final AtomicBoolean isConnected = new AtomicBoolean(false);

    public static String getHostDetails(SocketAddress socketAddress) {
        StringBuilder builder = new StringBuilder();
        EndPoint.getHostDetails(builder, socketAddress);
        return builder.toString();
    }

    public static void getHostDetails(StringBuilder stringBuilder, SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            String hostAddress;
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            InetAddress address1 = address.getAddress();
            String hostName = address1.getHostName();
            if (!hostName.equals(hostAddress = address1.getHostAddress())) {
                stringBuilder.append(hostName).append('/').append(hostAddress);
            } else {
                stringBuilder.append(hostAddress);
            }
            stringBuilder.append(':').append(address.getPort());
        } else if (socketAddress instanceof LocalAddress) {
            stringBuilder.append(socketAddress.toString());
        }
    }

    public EndPoint(Class<? extends EndPoint> type, Configuration config) throws SecurityException {
        super(type);
        if (config.host != null && (config.host.equals("localhost") || config.host.startsWith("127."))) {
            config.host = NetUtil.LOCALHOST.getHostAddress();
        }
        this.serializationManager = config.serialization != null ? config.serialization : Serialization.DEFAULT();
        this.rmiEnabled = this.serializationManager.initRmiSerialization();
        this.rmiExecutor = config.rmiExecutor;
        this.registrationWrapper = new RegistrationWrapper(this, this.logger);
        this.propertyStore = config.settingsStore == null ? new PropertyStore() : config.settingsStore;
        this.propertyStore.init(this.serializationManager, null);
        config.settingsStore = null;
        if (!(this.propertyStore instanceof NullSettingsStore)) {
            ECPrivateKeyParameters privateKey = this.propertyStore.getPrivateKey();
            ECPublicKeyParameters publicKey = this.propertyStore.getPublicKey();
            if (privateKey == null || publicKey == null) {
                try {
                    byte[] seedBytes = Entropy.get("There are no ECC keys for the " + type.getSimpleName() + " yet");
                    SecureRandom secureRandom = new SecureRandom(seedBytes);
                    secureRandom.nextBytes(seedBytes);
                    this.logger.debug("Now generating ECC (curve25519) keys. Please wait!");
                    AsymmetricCipherKeyPair generateKeyPair = CryptoECC.generateKeyPair("curve25519", secureRandom);
                    privateKey = (ECPrivateKeyParameters)generateKeyPair.getPrivate();
                    publicKey = (ECPublicKeyParameters)generateKeyPair.getPublic();
                    this.propertyStore.savePrivateKey(privateKey);
                    this.propertyStore.savePublicKey(publicKey);
                    this.logger.debug("Done with ECC keys!");
                }
                catch (Exception e) {
                    String message = "Unable to initialize/generate ECC keys. FORCED SHUTDOWN.";
                    this.logger.error(message);
                    throw new SecurityException(message);
                }
            }
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        } else {
            this.privateKey = null;
            this.publicKey = null;
        }
        this.secureRandom = new SecureRandom(this.propertyStore.getSalt());
        this.connectionManager = new ConnectionManager(type.getSimpleName(), this.connection0(null, null).getClass());
        if (this.rmiEnabled) {
            this.rmiHandler = null;
            this.localRmiHandler = new RmiObjectLocalHandler(this.logger);
            this.networkRmiHandler = new RmiObjectNetworkHandler(this.logger);
            this.globalRmiBridge = new RmiBridge(this.logger, config.rmiExecutor, true);
        } else {
            this.rmiHandler = new RmiObjectHandler();
            this.localRmiHandler = null;
            this.networkRmiHandler = null;
            this.globalRmiBridge = null;
        }
        Logger readLogger = LoggerFactory.getLogger((String)(type.getSimpleName() + ".READ"));
        Logger writeLogger = LoggerFactory.getLogger((String)(type.getSimpleName() + ".WRITE"));
        this.serializationManager.finishInit(readLogger, writeLogger);
    }

    public void disableRemoteKeyValidation() {
        if (this.isConnected.get()) {
            this.logger.error("Cannot disable the remote key validation after this endpoint is connected!");
        } else {
            this.logger.info("WARNING: Disabling remote key validation is a security risk!!");
            this.disableRemoteKeyValidation = true;
        }
    }

    public <S extends SettingsStore> S getPropertyStore() {
        return (S)this.propertyStore;
    }

    protected boolean hasMoreRegistrations() {
        return false;
    }

    protected void startNextProtocolRegistration() {
    }

    public int getIdleTimeout() {
        return this.idleTimeoutMs;
    }

    public void setIdleTimeout(int idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public CryptoSerializationManager getSerialization() {
        return this.serializationManager;
    }

    protected <E extends EndPoint> ConnectionImpl newConnection(Logger logger, E endPoint, RmiBridge rmiBridge) {
        return new ConnectionImpl(logger, endPoint, rmiBridge);
    }

    protected final ConnectionImpl connection0(MetaChannel metaChannel, InetSocketAddress remoteAddress) {
        ConnectionImpl connection;
        RmiBridge rmiBridge = null;
        if (metaChannel != null && this.rmiEnabled) {
            rmiBridge = new RmiBridge(this.logger, this.rmiExecutor, false);
        }
        if (metaChannel != null) {
            connection = this.newConnection(this.logger, this, rmiBridge);
            ChannelWrapper wrapper = metaChannel.localChannel != null ? (this.rmiEnabled ? new ChannelLocalWrapper(metaChannel, this.localRmiHandler) : new ChannelLocalWrapper(metaChannel, this.rmiHandler)) : (this.rmiEnabled ? new ChannelNetworkWrapper(metaChannel, remoteAddress, this.networkRmiHandler) : new ChannelNetworkWrapper(metaChannel, remoteAddress, this.rmiHandler));
            connection.init(wrapper, this.connectionManager);
            this.isConnected.set(true);
            this.connectionManager.addConnection(connection);
        } else {
            connection = this.newConnection(null, null, null);
        }
        return connection;
    }

    void connectionConnected0(ConnectionImpl connection) {
        this.connectionManager.onConnected(connection);
    }

    public final Listeners listeners() {
        return this.connectionManager;
    }

    public <C extends Connection> List<C> getConnections() {
        return this.connectionManager.getConnections();
    }

    public abstract ConnectionBridgeBase send();

    public abstract ConnectionPoint send(Object var1);

    void closeConnections(boolean shouldKeepListeners) {
    }

    @Override
    protected boolean shouldShutdownHookRun() {
        return this.connectionManager != null && !this.connectionManager.shutdown.get();
    }

    @Override
    protected void shutdownChannelsPre() {
        this.connectionManager.stop();
    }

    @Override
    protected void stopExtraActionsInternal() {
        this.propertyStore.close();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPoint other = (EndPoint)obj;
        if (this.privateKey == null ? other.privateKey != null : !CryptoECC.compare(this.privateKey, other.privateKey)) {
            return false;
        }
        return !(this.publicKey == null ? other.publicKey != null : !CryptoECC.compare(this.publicKey, other.publicKey));
    }

    public <T> int createGlobalObject(T globalObject) {
        return this.globalRmiBridge.register(globalObject);
    }

    public <T> T getGlobalObject(int objectRmiId) {
        return (T)this.globalRmiBridge.getRegisteredObject(objectRmiId);
    }
}

