/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.Client;
import dorkbox.network.Configuration;
import dorkbox.network.connection.BootstrapWrapper;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.Ping;
import dorkbox.network.connection.bridge.ConnectionBridge;
import dorkbox.util.exceptions.SecurityException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EndPointClient
extends EndPoint {
    protected volatile Connection connection;
    private CountDownLatch registration;
    private final Object bootstrapLock = new Object();
    protected List<BootstrapWrapper> bootstraps = new LinkedList<BootstrapWrapper>();
    private Iterator<BootstrapWrapper> bootstrapIterator;
    protected volatile int connectionTimeout = 5000;
    private volatile ConnectionBridge connectionBridgeFlushAlways;

    public EndPointClient(Configuration config) throws SecurityException {
        super(Client.class, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRegistration() throws IOException {
        Object object = this.bootstrapLock;
        synchronized (object) {
            this.registration = new CountDownLatch(1);
            this.bootstrapIterator = this.bootstraps.iterator();
            this.doRegistration();
        }
        try {
            if (!this.registration.await(this.connectionTimeout, TimeUnit.MILLISECONDS)) {
                this.closeConnection();
                throw new IOException("Unable to complete registration within '" + this.connectionTimeout + "' milliseconds");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to complete registration within '" + this.connectionTimeout + "' milliseconds", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startNextProtocolRegistration() {
        this.logger.trace("Registered protocol from server.");
        Object object = this.bootstrapLock;
        synchronized (object) {
            if (this.hasMoreRegistrations()) {
                this.doRegistration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasMoreRegistrations() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            return this.bootstrapIterator != null && this.bootstrapIterator.hasNext();
        }
    }

    private void doRegistration() {
        ChannelFuture future;
        BootstrapWrapper bootstrapWrapper = this.bootstrapIterator.next();
        if (this.connectionTimeout != 0) {
            bootstrapWrapper.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout);
        }
        try {
            future = bootstrapWrapper.bootstrap.connect();
            future.await((long)this.connectionTimeout);
        }
        catch (Exception e) {
            String errorMessage = "Could not connect to the " + bootstrapWrapper.type + " server at " + bootstrapWrapper.address + " on port: " + bootstrapWrapper.port;
            if (this.logger.isDebugEnabled()) {
                this.logger.error(errorMessage, (Throwable)e);
            } else {
                this.logger.error(errorMessage);
            }
            return;
        }
        if (!future.isSuccess()) {
            Throwable cause = future.cause();
            String errorMessage = "Connection refused  :" + bootstrapWrapper.address + " at " + bootstrapWrapper.type + " port: " + bootstrapWrapper.port;
            if (cause instanceof ConnectException) {
                if (cause.getMessage().contains("refused")) {
                    this.logger.error(errorMessage);
                }
            } else {
                this.logger.error(errorMessage, cause);
            }
            return;
        }
        this.logger.trace("Waiting for registration from server.");
        this.manageForShutdown(future);
    }

    @Override
    final void connectionConnected0(final ConnectionImpl connection) {
        this.connectionBridgeFlushAlways = new ConnectionBridge(){

            @Override
            public ConnectionPoint self(Object message) {
                ConnectionPoint self = connection.self(message);
                connection.flush();
                return self;
            }

            @Override
            public ConnectionPoint TCP(Object message) {
                ConnectionPoint tcp = connection.TCP(message);
                connection.flush();
                connection.controlBackPressure(tcp);
                return tcp;
            }

            @Override
            public ConnectionPoint UDP(Object message) {
                ConnectionPoint udp = connection.UDP(message);
                connection.flush();
                connection.controlBackPressure(udp);
                return udp;
            }

            @Override
            public Ping ping() {
                Ping ping = connection.ping();
                connection.flush();
                return ping;
            }
        };
        this.connection = connection;
        this.stopRegistration();
        super.connectionConnected0(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRegistration() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            this.bootstrapIterator = null;
            while (this.registration.getCount() > 0L) {
                this.registration.countDown();
            }
        }
    }

    protected void startUdpHeartbeat() {
    }

    @Override
    public ConnectionBridge send() {
        return this.connectionBridgeFlushAlways;
    }

    @Override
    public ConnectionPoint send(Object message) {
        ConnectionPoint send = this.connection.send(message);
        send.flush();
        ((ConnectionImpl)this.connection).controlBackPressure(send);
        return send;
    }

    protected void closeConnection() {
        if (this.isConnected.get()) {
            this.stopRegistration();
            this.connectionManager.closeConnections(true);
            this.registrationWrapper.clearSessions();
            this.closeConnections(true);
            this.shutdownAllChannels();
            this.connection = null;
            this.isConnected.set(false);
        }
    }

    void abortRegistration() {
        this.stopRegistration();
    }
}

