/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.Kryo;
import dorkbox.network.connection.CryptoConnection;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.RmiConnection;
import dorkbox.network.pipeline.ByteBufInput;
import dorkbox.network.pipeline.ByteBufOutput;
import dorkbox.network.serialization.CryptoSerializationManager;
import dorkbox.util.bytes.BigEndian;
import dorkbox.util.bytes.OptimizeUtilsByteArray;
import dorkbox.util.bytes.OptimizeUtilsByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class KryoExtra<C extends CryptoConnection>
extends Kryo {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final ByteBufInput reader = new ByteBufInput();
    private final ByteBufOutput writer = new ByteBufOutput();
    public volatile RmiConnection connection;
    private final GCMBlockCipher aesEngine = new GCMBlockCipher((BlockCipher)new AESFastEngine());
    private final ByteBuf tempBuffer = Unpooled.buffer((int)EndPoint.udpMaxSize);
    private LZ4Compressor compressor = factory.fastCompressor();
    private int inputArrayLength = -1;
    private byte[] inputArray;
    private int compressOutputLength = -1;
    private byte[] compressOutput;
    private int cryptoOutputLength = -1;
    private byte[] cryptoOutput;
    private LZ4FastDecompressor decompressor = factory.fastDecompressor();
    private int decryptOutputLength = -1;
    private byte[] decryptOutput;
    private ByteBuf decryptBuf;
    private int decompressOutputLength = -1;
    private byte[] decompressOutput;
    private ByteBuf decompressBuf;
    private CryptoSerializationManager serializationManager;

    public KryoExtra(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    public synchronized void write(ByteBuf buffer, Object message) throws IOException {
        this.connection = null;
        this.writer.setBuffer(buffer);
        this.writeClassAndObject(this.writer, message);
    }

    public synchronized Object read(ByteBuf buffer) throws IOException {
        this.connection = null;
        ByteBuf inputBuf = buffer;
        this.reader.setBuffer(inputBuf);
        return this.readClassAndObject(this.reader);
    }

    public synchronized void writeCompressed(C connection, ByteBuf buffer, Object message) throws IOException {
        int inputOffset;
        byte[] inputArray;
        this.connection = connection;
        ByteBuf objectOutputBuffer = this.tempBuffer;
        objectOutputBuffer.clear();
        this.writer.setBuffer(objectOutputBuffer);
        this.writeClassAndObject(this.writer, message);
        int length = objectOutputBuffer.writerIndex();
        if (objectOutputBuffer.hasArray() && objectOutputBuffer.array()[0] == objectOutputBuffer.getByte(0) && objectOutputBuffer.array().length == objectOutputBuffer.capacity()) {
            inputArray = objectOutputBuffer.array();
            this.inputArrayLength = -1;
            inputOffset = objectOutputBuffer.arrayOffset();
        } else {
            if (length > this.inputArrayLength) {
                this.inputArrayLength = length;
                this.inputArray = inputArray = new byte[length];
            } else {
                inputArray = this.inputArray;
            }
            objectOutputBuffer.getBytes(objectOutputBuffer.readerIndex(), inputArray, 0, length);
            inputOffset = 0;
        }
        byte[] compressOutput = this.compressOutput;
        int maxLengthLengthOffset = 4;
        int maxCompressedLength = this.compressor.maxCompressedLength(length);
        int maxCompressedLengthWithOffset = maxCompressedLength + maxLengthLengthOffset;
        if (maxCompressedLengthWithOffset > this.compressOutputLength) {
            this.compressOutputLength = maxCompressedLengthWithOffset;
            this.compressOutput = compressOutput = new byte[maxCompressedLengthWithOffset];
        }
        int compressedLength = this.compressor.compress(inputArray, inputOffset, length, compressOutput, maxLengthLengthOffset, maxCompressedLength);
        int lengthLength = OptimizeUtilsByteArray.intLength(length, true);
        inputArray = compressOutput;
        inputOffset = maxLengthLengthOffset - lengthLength;
        OptimizeUtilsByteArray.writeInt(inputArray, length, true, inputOffset);
        buffer.writeBytes(inputArray, inputOffset, compressedLength + lengthLength);
    }

    public Object readCompressed(C connection, ByteBuf buffer, int length) throws IOException {
        int inputOffset;
        byte[] inputArray;
        this.connection = connection;
        ByteBuf inputBuf = buffer;
        int uncompressedLength = OptimizeUtilsByteBuf.readInt(buffer, true);
        int lengthLength = OptimizeUtilsByteArray.intLength(uncompressedLength, true);
        length -= lengthLength;
        if (inputBuf.hasArray() && inputBuf.array()[0] == inputBuf.getByte(0) && inputBuf.array().length == inputBuf.capacity()) {
            inputArray = inputBuf.array();
            this.inputArrayLength = -1;
            inputOffset = inputBuf.arrayOffset();
        } else {
            if (length > this.inputArrayLength) {
                this.inputArrayLength = length;
                this.inputArray = inputArray = new byte[length];
            } else {
                inputArray = this.inputArray;
            }
            inputBuf.getBytes(inputBuf.readerIndex(), inputArray, 0, length);
            inputOffset = 0;
        }
        buffer.readerIndex(buffer.readerIndex() + length);
        byte[] decompressOutputArray = this.decompressOutput;
        if (uncompressedLength > this.decompressOutputLength) {
            this.decompressOutputLength = uncompressedLength;
            this.decompressOutput = decompressOutputArray = new byte[uncompressedLength];
            this.decompressBuf = Unpooled.wrappedBuffer((byte[])decompressOutputArray);
        }
        inputBuf = this.decompressBuf;
        this.decompressor.decompress(inputArray, inputOffset, decompressOutputArray, 0, uncompressedLength);
        inputBuf.setIndex(0, uncompressedLength);
        this.reader.setBuffer(inputBuf);
        return this.readClassAndObject(this.reader);
    }

    public synchronized void writeCrypto(C connection, ByteBuf buffer, Object message) throws IOException {
        byte[] cryptoOutput;
        int inputOffset;
        byte[] inputArray;
        this.connection = connection;
        ByteBuf objectOutputBuffer = this.tempBuffer;
        objectOutputBuffer.clear();
        this.writer.setBuffer(objectOutputBuffer);
        this.writeClassAndObject(this.writer, message);
        int length = objectOutputBuffer.writerIndex();
        if (objectOutputBuffer.hasArray() && objectOutputBuffer.array()[0] == objectOutputBuffer.getByte(0) && objectOutputBuffer.array().length == objectOutputBuffer.capacity()) {
            inputArray = objectOutputBuffer.array();
            this.inputArrayLength = -1;
            inputOffset = objectOutputBuffer.arrayOffset();
        } else {
            if (length > this.inputArrayLength) {
                this.inputArrayLength = length;
                this.inputArray = inputArray = new byte[length];
            } else {
                inputArray = this.inputArray;
            }
            objectOutputBuffer.getBytes(objectOutputBuffer.readerIndex(), inputArray, 0, length);
            inputOffset = 0;
        }
        byte[] compressOutput = this.compressOutput;
        int maxLengthLengthOffset = 4;
        int maxCompressedLength = this.compressor.maxCompressedLength(length);
        int maxCompressedLengthWithOffset = maxCompressedLength + maxLengthLengthOffset;
        if (maxCompressedLengthWithOffset > this.compressOutputLength) {
            this.compressOutputLength = maxCompressedLengthWithOffset;
            this.compressOutput = compressOutput = new byte[maxCompressedLengthWithOffset];
        }
        int compressedLength = this.compressor.compress(inputArray, inputOffset, length, compressOutput, maxLengthLengthOffset, maxCompressedLength);
        int lengthLength = OptimizeUtilsByteArray.intLength(length, true);
        inputArray = compressOutput;
        inputOffset = maxLengthLengthOffset - lengthLength;
        OptimizeUtilsByteArray.writeInt(inputArray, length, true, inputOffset);
        length = compressedLength + lengthLength;
        long nextGcmSequence = connection.getNextGcmSequence();
        ParametersWithIV cryptoParameters = connection.getCryptoParameters();
        BigEndian.Long_.toBytes(nextGcmSequence, cryptoParameters.getIV(), 4);
        GCMBlockCipher aes = this.aesEngine;
        aes.reset();
        aes.init(true, (CipherParameters)cryptoParameters);
        int cryptoSize = length + 16;
        if (cryptoSize > this.cryptoOutputLength) {
            this.cryptoOutputLength = cryptoSize;
            this.cryptoOutput = cryptoOutput = new byte[cryptoSize];
        } else {
            cryptoOutput = this.cryptoOutput;
        }
        int encryptedLength = aes.processBytes(inputArray, inputOffset, length, cryptoOutput, 0);
        try {
            encryptedLength += aes.doFinal(cryptoOutput, encryptedLength);
        }
        catch (Exception e) {
            throw new IOException("Unable to AES encrypt the data", e);
        }
        OptimizeUtilsByteBuf.writeLong(buffer, nextGcmSequence, true);
        buffer.writeBytes(cryptoOutput, 0, encryptedLength);
    }

    public Object readCrypto(C connection, ByteBuf buffer, int length) throws IOException {
        byte[] decryptOutputArray;
        int inputOffset;
        byte[] inputArray;
        this.connection = connection;
        ByteBuf inputBuf = buffer;
        long gcmIVCounter = OptimizeUtilsByteBuf.readLong(buffer, true);
        length -= OptimizeUtilsByteArray.longLength(gcmIVCounter, true);
        if (inputBuf.hasArray() && inputBuf.array()[0] == inputBuf.getByte(0) && inputBuf.array().length == inputBuf.capacity()) {
            inputArray = inputBuf.array();
            this.inputArrayLength = -1;
            inputOffset = inputBuf.arrayOffset();
        } else {
            if (length > this.inputArrayLength) {
                this.inputArrayLength = length;
                this.inputArray = inputArray = new byte[length];
            } else {
                inputArray = this.inputArray;
            }
            inputBuf.getBytes(inputBuf.readerIndex(), inputArray, 0, length);
            inputOffset = 0;
        }
        buffer.readerIndex(buffer.readerIndex() + length);
        ParametersWithIV cryptoParameters = connection.getCryptoParameters();
        BigEndian.Long_.toBytes(gcmIVCounter, cryptoParameters.getIV(), 4);
        GCMBlockCipher aes = this.aesEngine;
        aes.reset();
        aes.init(false, (CipherParameters)cryptoParameters);
        int cryptoSize = length - 16;
        if (cryptoSize > this.decryptOutputLength) {
            this.decryptOutputLength = cryptoSize;
            this.decryptOutput = decryptOutputArray = new byte[cryptoSize];
            this.decryptBuf = Unpooled.wrappedBuffer((byte[])decryptOutputArray);
        } else {
            decryptOutputArray = this.decryptOutput;
        }
        int decryptedLength = aes.processBytes(inputArray, inputOffset, length, decryptOutputArray, 0);
        try {
            decryptedLength += aes.doFinal(decryptOutputArray, decryptedLength);
        }
        catch (Exception e) {
            throw new IOException("Unable to AES decrypt the data", e);
        }
        inputArray = decryptOutputArray;
        int uncompressedLength = OptimizeUtilsByteArray.readInt(inputArray, true);
        inputOffset = OptimizeUtilsByteArray.intLength(uncompressedLength, true);
        byte[] decompressOutputArray = this.decompressOutput;
        if (uncompressedLength > this.decompressOutputLength) {
            this.decompressOutputLength = uncompressedLength;
            this.decompressOutput = decompressOutputArray = new byte[uncompressedLength];
            this.decompressBuf = Unpooled.wrappedBuffer((byte[])decompressOutputArray);
        }
        inputBuf = this.decompressBuf;
        this.decompressor.decompress(inputArray, inputOffset, decompressOutputArray, 0, uncompressedLength);
        inputBuf.setIndex(0, uncompressedLength);
        this.reader.setBuffer(inputBuf);
        return this.readClassAndObject(this.reader);
    }

    protected void finalize() throws Throwable {
        if (this.decompressBuf != null) {
            this.decompressBuf.release();
        }
        if (this.decryptBuf != null) {
            this.decryptBuf.release();
        }
        super.finalize();
    }

    public CryptoSerializationManager getSerializationManager() {
        return this.serializationManager;
    }
}

