/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.store.DB_Server;
import dorkbox.network.store.SettingsStore;
import dorkbox.util.bytes.ByteArrayWrapper;
import dorkbox.util.exceptions.SecurityException;
import dorkbox.util.serialization.SerializationManager;
import dorkbox.util.storage.Storage;
import dorkbox.util.storage.StorageSystem;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

final class PropertyStore
extends SettingsStore {
    private Storage storage;
    private Map<ByteArrayWrapper, DB_Server> servers;

    PropertyStore() {
    }

    @Override
    public void init(SerializationManager serializationManager, Storage ignored) {
        if (serializationManager != null && !serializationManager.initialized()) {
            serializationManager.register(HashMap.class);
            serializationManager.register(ByteArrayWrapper.class);
            serializationManager.register(DB_Server.class);
        }
        this.storage = StorageSystem.Memory().build();
        this.servers = this.storage.get(DB_Server.STORAGE_KEY, new HashMap(16));
        DB_Server localServer = this.servers.get(DB_Server.IP_SELF);
        if (localServer == null) {
            localServer = new DB_Server();
            this.servers.put(DB_Server.IP_SELF, localServer);
            this.storage.put(DB_Server.STORAGE_KEY, this.servers);
        }
    }

    @Override
    public synchronized ECPrivateKeyParameters getPrivateKey() throws SecurityException {
        PropertyStore.checkAccess(EndPoint.class);
        return this.servers.get(DB_Server.IP_SELF).getPrivateKey();
    }

    @Override
    public synchronized void savePrivateKey(ECPrivateKeyParameters serverPrivateKey) throws SecurityException {
        PropertyStore.checkAccess(EndPoint.class);
        this.servers.get(DB_Server.IP_SELF).setPrivateKey(serverPrivateKey);
        this.storage.put(DB_Server.STORAGE_KEY, this.servers);
    }

    @Override
    public synchronized ECPublicKeyParameters getPublicKey() throws SecurityException {
        PropertyStore.checkAccess(EndPoint.class);
        return this.servers.get(DB_Server.IP_SELF).getPublicKey();
    }

    @Override
    public synchronized void savePublicKey(ECPublicKeyParameters serverPublicKey) throws SecurityException {
        PropertyStore.checkAccess(EndPoint.class);
        this.servers.get(DB_Server.IP_SELF).setPublicKey(serverPublicKey);
        this.storage.put(DB_Server.STORAGE_KEY, this.servers);
    }

    @Override
    public synchronized byte[] getSalt() {
        DB_Server localServer = this.servers.get(DB_Server.IP_SELF);
        byte[] salt = localServer.getSalt();
        if (salt == null) {
            SecureRandom secureRandom = new SecureRandom();
            byte[] bytes = new byte[256];
            secureRandom.nextBytes(bytes);
            salt = bytes;
            localServer.setSalt(bytes);
            this.storage.put(DB_Server.STORAGE_KEY, this.servers);
        }
        return salt;
    }

    @Override
    public synchronized ECPublicKeyParameters getRegisteredServerKey(byte[] hostAddress) throws SecurityException {
        PropertyStore.checkAccess(RegistrationWrapper.class);
        DB_Server db_server = this.servers.get(ByteArrayWrapper.wrap(hostAddress));
        if (db_server != null) {
            return db_server.getPublicKey();
        }
        return null;
    }

    @Override
    public synchronized void addRegisteredServerKey(byte[] hostAddress, ECPublicKeyParameters publicKey) throws SecurityException {
        PropertyStore.checkAccess(RegistrationWrapper.class);
        ByteArrayWrapper wrap = ByteArrayWrapper.wrap(hostAddress);
        DB_Server db_server = this.servers.get(wrap);
        if (db_server == null) {
            db_server = new DB_Server();
        }
        db_server.setPublicKey(publicKey);
        this.servers.put(wrap, db_server);
    }

    @Override
    public synchronized boolean removeRegisteredServerKey(byte[] hostAddress) throws SecurityException {
        PropertyStore.checkAccess(RegistrationWrapper.class);
        ByteArrayWrapper wrap = ByteArrayWrapper.wrap(hostAddress);
        DB_Server db_server = this.servers.remove(wrap);
        return db_server != null;
    }

    @Override
    public void close() {
        StorageSystem.close(this.storage);
    }
}

