/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointClient;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.pipeline.tcp.KryoEncoder;
import dorkbox.network.pipeline.tcp.KryoEncoderCrypto;
import dorkbox.network.pipeline.udp.KryoDecoderUdp;
import dorkbox.network.pipeline.udp.KryoDecoderUdpCrypto;
import dorkbox.network.pipeline.udp.KryoEncoderUdp;
import dorkbox.network.pipeline.udp.KryoEncoderUdpCrypto;
import dorkbox.network.serialization.CryptoSerializationManager;
import dorkbox.util.RandomUtil;
import dorkbox.util.collections.IntMap;
import dorkbox.util.collections.LockFreeIntMap;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.exceptions.SecurityException;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.LinkedList;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;

public class RegistrationWrapper {
    private final Logger logger;
    public final KryoEncoder kryoTcpEncoder;
    public final KryoEncoderCrypto kryoTcpEncoderCrypto;
    public final KryoEncoderUdp kryoUdpEncoder;
    public final KryoEncoderUdpCrypto kryoUdpEncoderCrypto;
    public final KryoDecoderUdp kryoUdpDecoder;
    public final KryoDecoderUdpCrypto kryoUdpDecoderCrypto;
    private final EndPoint endPoint;
    private final LockFreeIntMap<MetaChannel> sessionMap = new LockFreeIntMap(32, 0.8f);

    public RegistrationWrapper(EndPoint endPoint, Logger logger) {
        this.endPoint = endPoint;
        this.logger = logger;
        this.kryoTcpEncoder = new KryoEncoder(endPoint.serializationManager);
        this.kryoTcpEncoderCrypto = new KryoEncoderCrypto(endPoint.serializationManager);
        this.kryoUdpEncoder = new KryoEncoderUdp(endPoint.serializationManager);
        this.kryoUdpEncoderCrypto = new KryoEncoderUdpCrypto(endPoint.serializationManager);
        this.kryoUdpDecoder = new KryoDecoderUdp(endPoint.serializationManager);
        this.kryoUdpDecoderCrypto = new KryoDecoderUdpCrypto(endPoint.serializationManager);
    }

    public CryptoSerializationManager getSerializtion() {
        return this.endPoint.getSerialization();
    }

    public int getIdleTimeout() {
        return this.endPoint.getIdleTimeout();
    }

    public boolean hasMoreRegistrations() {
        return this.endPoint.hasMoreRegistrations();
    }

    public void startNextProtocolRegistration() {
        this.endPoint.startNextProtocolRegistration();
    }

    public void connectionConnected0(ConnectionImpl connection) {
        this.endPoint.connectionConnected0(connection);
    }

    public ConnectionImpl connection0(MetaChannel metaChannel, InetSocketAddress remoteAddress) {
        return this.endPoint.connection0(metaChannel, remoteAddress);
    }

    public SecureRandom getSecureRandom() {
        return this.endPoint.secureRandom;
    }

    public ECPublicKeyParameters getPublicKey() {
        return this.endPoint.publicKey;
    }

    public boolean validateRemoteAddress(MetaChannel metaChannel, InetSocketAddress remoteAddress, ECPublicKeyParameters publicKey) {
        block7: {
            InetAddress address = remoteAddress.getAddress();
            byte[] hostAddress = address.getAddress();
            try {
                String byAddress;
                ECPublicKeyParameters savedPublicKey = this.endPoint.propertyStore.getRegisteredServerKey(hostAddress);
                Logger logger2 = this.logger;
                if (savedPublicKey == null) {
                    if (logger2.isDebugEnabled()) {
                        logger2.debug("Adding new remote IP address key for {}", (Object)address.getHostAddress());
                    }
                    this.endPoint.propertyStore.addRegisteredServerKey(hostAddress, publicKey);
                    break block7;
                }
                if (CryptoECC.compare(publicKey, savedPublicKey)) break block7;
                try {
                    byAddress = InetAddress.getByAddress(hostAddress).getHostAddress();
                }
                catch (UnknownHostException e) {
                    byAddress = "Unknown Address";
                }
                if (this.endPoint.disableRemoteKeyValidation) {
                    logger2.warn("Invalid or non-matching public key from remote connection, their public key has changed. Toggling extra flag in channel to indicate key change. To fix, remove entry for: {}", (Object)byAddress);
                    metaChannel.changedRemoteKey = true;
                    return true;
                }
                logger2.error("Invalid or non-matching public key from remote connection, their public key has changed. To fix, remove entry for: {}", (Object)byAddress);
                return false;
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    public void removeRegisteredServerKey(byte[] hostAddress) throws SecurityException {
        ECPublicKeyParameters savedPublicKey = this.endPoint.propertyStore.getRegisteredServerKey(hostAddress);
        if (savedPublicKey != null) {
            Logger logger2 = this.logger;
            if (logger2.isDebugEnabled()) {
                logger2.debug("Deleting remote IP address key {}.{}.{}.{}", new Object[]{hostAddress[0], hostAddress[1], hostAddress[2], hostAddress[3]});
            }
            this.endPoint.propertyStore.removeRegisteredServerKey(hostAddress);
        }
    }

    public void abortRegistrationIfClient() {
        if (this.endPoint instanceof EndPointClient) {
            ((EndPointClient)this.endPoint).abortRegistration();
        }
    }

    public boolean isClient() {
        return this.endPoint instanceof EndPointClient;
    }

    public MetaChannel createSessionClient(int sessionId) {
        MetaChannel metaChannel = new MetaChannel(sessionId);
        this.sessionMap.put(sessionId, metaChannel);
        return metaChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaChannel createSessionServer() {
        MetaChannel metaChannel;
        int sessionId = RandomUtil.int_();
        while (sessionId == 0 && this.sessionMap.containsKey(sessionId)) {
            sessionId = RandomUtil.int_();
        }
        LockFreeIntMap<MetaChannel> lockFreeIntMap = this.sessionMap;
        synchronized (lockFreeIntMap) {
            while (sessionId == 0 && this.sessionMap.containsKey(sessionId)) {
                sessionId = RandomUtil.int_();
            }
            metaChannel = new MetaChannel(sessionId);
            this.sessionMap.put(sessionId, metaChannel);
        }
        return metaChannel;
    }

    public MetaChannel getSession(int sessionId) {
        return this.sessionMap.get(sessionId);
    }

    public MetaChannel getFirstSession() {
        IntMap.Values<MetaChannel> values = this.sessionMap.values();
        if (values.hasNext) {
            return values.next();
        }
        return null;
    }

    public void removeSession(MetaChannel metaChannel) {
        int sessionId = metaChannel.sessionId;
        if (sessionId != 0) {
            this.sessionMap.remove(sessionId);
        }
    }

    public void closeSession(int sessionId) {
        MetaChannel metaChannel;
        if (sessionId != 0 && (metaChannel = this.sessionMap.remove(sessionId)) != null) {
            if (metaChannel.tcpChannel != null && metaChannel.tcpChannel.isOpen()) {
                metaChannel.tcpChannel.close();
            }
            if (metaChannel.udpChannel != null && metaChannel.udpChannel.isOpen()) {
                metaChannel.udpChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessions() {
        LinkedList<Channel> channels = new LinkedList<Channel>();
        LockFreeIntMap<MetaChannel> lockFreeIntMap = this.sessionMap;
        synchronized (lockFreeIntMap) {
            IntMap.Values<MetaChannel> values = this.sessionMap.values();
            for (MetaChannel metaChannel : values) {
                if (metaChannel.tcpChannel != null && metaChannel.tcpChannel.isOpen()) {
                    channels.add(metaChannel.tcpChannel);
                }
                if (metaChannel.udpChannel == null || !metaChannel.udpChannel.isOpen()) continue;
                channels.add(metaChannel.udpChannel);
            }
            this.sessionMap.clear();
        }
        for (Channel channel : channels) {
            channel.close();
        }
    }
}

