/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.NativeLibrary;
import dorkbox.network.pipeline.ConnectionType;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdownable {
    protected static final String shutdownHookName = "::SHUTDOWN_HOOK::";
    protected static final String stopTreadName = "::STOP_THREAD::";
    public static final String THREADGROUP_NAME = "(Netty)";
    @Property
    public static final int WRITE_BUFF_HIGH = 32768;
    @Property
    public static final int WRITE_BUFF_LOW = 8192;
    @Property
    public static int WORKER_THREAD_POOL_SIZE;
    @Property
    public static long maxShutdownWaitTimeInMilliSeconds;
    protected final Logger logger;
    protected final ThreadGroup threadGroup;
    protected final Class<? extends Shutdownable> type;
    protected final Object shutdownInProgress = new Object();
    private volatile boolean isShutdown = false;
    private final List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>(8);
    private final List<ChannelFuture> shutdownChannelList = new ArrayList<ChannelFuture>();
    private Thread shutdownHook;
    private final CountDownLatch blockUntilDone = new CountDownLatch(1);
    private AtomicBoolean stopCalled = new AtomicBoolean(false);

    public static boolean isNettyThread() {
        return Thread.currentThread().getThreadGroup().getName().contains(THREADGROUP_NAME);
    }

    public static void runNewThread(String threadName, Runnable runnable) {
        Thread thread = new Thread(Thread.currentThread().getThreadGroup().getParent(), runnable);
        thread.setDaemon(true);
        thread.setName(threadName);
        thread.start();
    }

    public Shutdownable(Class<? extends Shutdownable> type) {
        this.type = type;
        SecurityManager s = System.getSecurityManager();
        this.threadGroup = new ThreadGroup(s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup(), type.getSimpleName() + " " + THREADGROUP_NAME);
        this.threadGroup.setDaemon(true);
        this.logger = LoggerFactory.getLogger((String)type.getSimpleName());
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                if (Shutdownable.this.shouldShutdownHookRun()) {
                    Shutdownable.this.stop();
                }
            }
        };
        this.shutdownHook.setName(shutdownHookName);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void manageForShutdown(ChannelFuture future) {
        List<ChannelFuture> list = this.shutdownChannelList;
        synchronized (list) {
            this.shutdownChannelList.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void manageForShutdown(EventLoopGroup loopGroup) {
        List<EventLoopGroup> list = this.eventLoopGroups;
        synchronized (list) {
            this.eventLoopGroups.add(loopGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeFromShutdown(EventLoopGroup loopGroup) {
        List<EventLoopGroup> list = this.eventLoopGroups;
        synchronized (list) {
            this.eventLoopGroups.remove(loopGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownAllChannels() {
        List<ChannelFuture> list = this.shutdownChannelList;
        synchronized (list) {
            for (ChannelFuture f : this.shutdownChannelList) {
                Channel channel = f.channel();
                if (!channel.isOpen()) continue;
                channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
                Thread.yield();
            }
            this.shutdownChannelList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownEventLoops() {
        ArrayList<EventLoopGroup> loopGroups;
        LinkedList<Future> shutdownThreadList = new LinkedList<Future>();
        Iterator iterator = this.eventLoopGroups;
        synchronized (iterator) {
            loopGroups = new ArrayList<EventLoopGroup>(this.eventLoopGroups.size());
            loopGroups.addAll(this.eventLoopGroups);
        }
        for (EventLoopGroup loopGroup : loopGroups) {
            shutdownThreadList.add(loopGroup.shutdownGracefully(maxShutdownWaitTimeInMilliSeconds, maxShutdownWaitTimeInMilliSeconds * 10L, TimeUnit.MILLISECONDS));
            Thread.yield();
        }
        for (Future f : shutdownThreadList) {
            f.syncUninterruptibly();
            Thread.yield();
        }
    }

    protected final String stopWithErrorMessage(Logger logger, String errorMessage, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(errorMessage, throwable.getCause());
        } else {
            logger.error(errorMessage);
        }
        this.stop();
        return errorMessage;
    }

    protected boolean shouldShutdownHookRun() {
        return true;
    }

    protected EventLoopGroup newEventLoop(int threadCount, String threadName) {
        if (OS.isAndroid()) {
            return this.newEventLoop(ConnectionType.OIO, threadCount, threadName);
        }
        if (OS.isLinux() && NativeLibrary.isAvailable()) {
            return this.newEventLoop(ConnectionType.EPOLL, threadCount, threadName);
        }
        if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
            return this.newEventLoop(ConnectionType.KQUEUE, threadCount, threadName);
        }
        return this.newEventLoop(ConnectionType.NIO, threadCount, threadName);
    }

    protected EventLoopGroup newEventLoop(ConnectionType connectionType, int threadCount, String threadName) {
        DefaultEventLoopGroup group;
        NamedThreadFactory threadFactory = new NamedThreadFactory(threadName, this.threadGroup);
        switch (connectionType) {
            case LOCAL: {
                group = new DefaultEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                break;
            }
            case OIO: {
                group = new OioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                break;
            }
            case NIO: {
                group = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                break;
            }
            case EPOLL: {
                group = new EpollEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                break;
            }
            case KQUEUE: {
                group = new KQueueEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                break;
            }
            default: {
                group = new DefaultEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
            }
        }
        this.manageForShutdown((EventLoopGroup)group);
        return group;
    }

    protected boolean isInEventLoop(Thread thread) {
        for (EventLoopGroup loopGroup : this.eventLoopGroups) {
            for (EventExecutor next : loopGroup) {
                if (!next.inEventLoop(thread)) continue;
                return true;
            }
        }
        return false;
    }

    public final void stop() {
        boolean isShutdownThread;
        if (!this.stopCalled.compareAndSet(false, true)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        boolean bl = isShutdownThread = !threadName.equals(shutdownHookName) && !threadName.equals(stopTreadName);
        if (!isShutdownThread || !this.isInEventLoop(currentThread)) {
            this.stopInThread();
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Shutdownable.this.stopInThread();
                }
            });
            thread.setDaemon(false);
            thread.setName(stopTreadName);
            thread.start();
        }
    }

    protected void stopExtraActions() {
    }

    protected void shutdownChannelsPre() {
    }

    protected void stopExtraActionsInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInThread() {
        Object object = this.shutdownInProgress;
        synchronized (object) {
            this.shutdownChannelsPre();
            this.shutdownAllChannels();
            this.shutdownEventLoops();
            this.logger.info("Stopping endpoint.");
            if (!Thread.currentThread().getName().equals(shutdownHookName)) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stopExtraActionsInternal();
            this.stopExtraActions();
            this.isShutdown = true;
        }
        this.blockUntilDone.countDown();
    }

    public final void waitForShutdown() {
        try {
            this.blockUntilDone.await();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted while waiting for stop!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isShutdown() {
        Object object = this.shutdownInProgress;
        synchronized (object) {
            return this.isShutdown;
        }
    }

    public String toString() {
        return "EndPoint [" + this.getName() + "]";
    }

    public String getName() {
        return this.type.getSimpleName();
    }

    static {
        try {
            System.setProperty("java.net.preferIPv4Stack", Boolean.TRUE.toString());
            System.setProperty("java.net.preferIPv6Addresses", Boolean.FALSE.toString());
            if (OS.javaVersion == 6 && PlatformDependent.hasUnsafe()) {
                PlatformDependent.newFixedMpscQueue((int)8);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        WORKER_THREAD_POOL_SIZE = Math.min(Runtime.getRuntime().availableProcessors() / 2, 1);
        maxShutdownWaitTimeInMilliSeconds = 2000L;
    }
}

