/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.idle;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.Listener;
import dorkbox.network.connection.idle.IdleListener;
import java.io.IOException;

public abstract class IdleSender<C extends Connection, M>
implements Listener.OnIdle<C> {
    final IdleListener<C, M> idleListener;
    volatile boolean started;

    public IdleSender(IdleListener<C, M> idleListener) {
        this.idleListener = idleListener;
    }

    @Override
    public void idle(C connection) throws IOException {
        M message;
        if (!this.started) {
            this.started = true;
            this.start();
        }
        if ((message = this.next()) == null) {
            connection.listeners().remove(this);
        } else {
            this.idleListener.send(connection, message);
        }
    }

    protected void start() {
    }

    protected abstract M next() throws IOException;
}

