/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.listenerManagement;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.Listener;
import dorkbox.util.collections.ConcurrentEntry;
import dorkbox.util.collections.ConcurrentIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class ConcurrentManager<C extends Connection, T extends Listener>
extends ConcurrentIterator<T> {
    private final Logger logger;

    ConcurrentManager(Logger logger) {
        this.logger = logger;
    }

    @Override
    public synchronized void add(T listener) {
        super.add(listener);
    }

    public synchronized int removeWithSize(T listener) {
        boolean removed = super.remove(listener);
        if (removed) {
            return super.size();
        }
        return -1;
    }

    boolean doAction(C connection, AtomicBoolean shutdown) {
        ConcurrentEntry head;
        ConcurrentEntry current = head = (ConcurrentEntry)headREF.get(this);
        while (current != null && !shutdown.get()) {
            Listener listener = (Listener)current.getValue();
            current = current.next();
            try {
                this.listenerAction(connection, listener);
            }
            catch (Exception e) {
                if (listener instanceof Listener.OnError) {
                    ((Listener.OnError)listener).error(connection, e);
                    continue;
                }
                this.logger.error("Unable to notify listener '{}', connection '{}'.", new Object[]{listener, connection, e});
            }
        }
        return head != null;
    }

    abstract void listenerAction(C var1, T var2) throws Exception;
}

