/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.local;

import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.RegistrationHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;

public abstract class RegistrationLocalHandler
extends RegistrationHandler {
    public static final AttributeKey<MetaChannel> META_CHANNEL = AttributeKey.valueOf(RegistrationLocalHandler.class, (String)"MetaChannel.local");

    RegistrationLocalHandler(String name, RegistrationWrapper registrationWrapper) {
        super(name, registrationWrapper, null);
    }

    @Override
    protected void initChannel(Channel channel) {
        MetaChannel metaChannel = this.registrationWrapper.createSessionServer();
        metaChannel.localChannel = channel;
        channel.attr(META_CHANNEL).set((Object)metaChannel);
        this.logger.trace("New LOCAL connection.");
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        this.logger.error("Unexpected exception while trying to receive data on LOCAL channel.  ({})" + System.getProperty("line.separator"), (Object)channel.remoteAddress(), (Object)cause);
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public final void channelInactive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        this.logger.info("Closed LOCAL connection: {}", (Object)channel.remoteAddress());
        super.channelInactive(context);
    }
}

