/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.local;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.local.RegistrationLocalHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;

public class RegistrationLocalHandlerServer
extends RegistrationLocalHandler {
    public RegistrationLocalHandlerServer(String name, RegistrationWrapper registrationWrapper) {
        super(name, registrationWrapper);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        this.logger.info("Connected to LOCAL connection. [{} <== {}]", (Object)context.channel().localAddress(), (Object)channel.remoteAddress());
        super.channelActive(context);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        ConnectionImpl connection;
        Channel channel = context.channel();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.remove((ChannelHandler)this);
        channel.writeAndFlush(message);
        ReferenceCountUtil.release((Object)message);
        this.logger.trace("Sent registration");
        MetaChannel metaChannel = (MetaChannel)channel.attr(META_CHANNEL).getAndSet(null);
        if (metaChannel != null && (connection = this.registrationWrapper.connection0(metaChannel, null)) != null) {
            pipeline.addLast("connection", (ChannelHandler)connection);
            this.registrationWrapper.connectionConnected0(connection);
        }
    }
}

