/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.ConnectionWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.RegistrationHandler;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientUDP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerUDP;
import dorkbox.network.pipeline.tcp.KryoDecoder;
import dorkbox.network.pipeline.tcp.KryoDecoderCrypto;
import dorkbox.network.serialization.CryptoSerializationManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;

public abstract class RegistrationRemoteHandler
extends RegistrationHandler {
    static final AttributeKey<LinkedList> MESSAGES = AttributeKey.valueOf(RegistrationRemoteHandler.class, (String)"messages");
    static final String DELETE_IP = "eleteIP";
    static final ECParameterSpec eccSpec = ECNamedCurveTable.getParameterSpec((String)"curve25519");
    static final String KRYO_ENCODER = "kryoEncoder";
    static final String KRYO_DECODER = "kryoDecoder";
    private static final String IDLE_HANDLER_FULL = "idleHandlerFull";
    private static final String FRAME_AND_KRYO_ENCODER = "frameAndKryoEncoder";
    private static final String FRAME_AND_KRYO_DECODER = "frameAndKryoDecoder";
    private static final String FRAME_AND_KRYO_CRYPTO_ENCODER = "frameAndKryoCryptoEncoder";
    private static final String FRAME_AND_KRYO_CRYPTO_DECODER = "frameAndKryoCryptoDecoder";
    private static final String KRYO_CRYPTO_ENCODER = "kryoCryptoEncoder";
    private static final String KRYO_CRYPTO_DECODER = "kryoCryptoDecoder";
    private static final String IDLE_HANDLER = "idleHandler";
    protected final CryptoSerializationManager serializationManager;

    RegistrationRemoteHandler(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
        this.serializationManager = registrationWrapper.getSerializtion();
    }

    @Override
    protected void initChannel(Channel channel) {
        boolean isUdpChannel;
        ChannelPipeline pipeline = channel.pipeline();
        Class<?> channelClass = channel.getClass();
        boolean isTcpChannel = ConnectionImpl.isTcpChannel(channelClass);
        boolean bl = isUdpChannel = !isTcpChannel && ConnectionImpl.isUdpChannel(channelClass);
        if (isTcpChannel) {
            pipeline.addFirst(FRAME_AND_KRYO_DECODER, (ChannelHandler)new KryoDecoder(this.serializationManager));
        } else if (isUdpChannel) {
            pipeline.addFirst(KRYO_DECODER, (ChannelHandler)this.registrationWrapper.kryoUdpDecoder);
        }
        pipeline.addFirst(IDLE_HANDLER, (ChannelHandler)new IdleStateHandler(2, 0, 0));
        if (isTcpChannel) {
            pipeline.addFirst(FRAME_AND_KRYO_ENCODER, (ChannelHandler)this.registrationWrapper.kryoTcpEncoder);
        } else if (isUdpChannel) {
            pipeline.addFirst(KRYO_ENCODER, (ChannelHandler)this.registrationWrapper.kryoUdpEncoder);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            Channel channel = context.channel();
            Class<?> channelClass = channel.getClass();
            boolean isUdp = ConnectionImpl.isUdpChannel(channelClass);
            StringBuilder stringBuilder = new StringBuilder(96);
            stringBuilder.append("Connected to remote ");
            if (ConnectionImpl.isTcpChannel(channelClass)) {
                stringBuilder.append("TCP");
            } else if (isUdp) {
                stringBuilder.append("UDP");
            } else if (ConnectionImpl.isLocalChannel(channelClass)) {
                stringBuilder.append("LOCAL");
            } else {
                stringBuilder.append("UNKNOWN");
            }
            stringBuilder.append(" connection  [");
            EndPoint.getHostDetails(stringBuilder, channel.localAddress());
            stringBuilder.append(this.getConnectionDirection());
            EndPoint.getHostDetails(stringBuilder, channel.remoteAddress());
            stringBuilder.append("]");
            this.logger.debug(stringBuilder.toString());
        }
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent && ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            Channel channel = context.channel();
            channel.close();
            return;
        }
        super.userEventTriggered(context, event);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        this.logger.error("Unexpected exception while trying to send/receive data on remote network channel.  ({})" + System.getProperty("line.separator"), (Object)channel.remoteAddress(), (Object)cause);
        if (channel.isOpen()) {
            channel.close();
        }
    }

    protected abstract String getConnectionDirection();

    final boolean invalidAES(MetaChannel metaChannel) {
        if (metaChannel.aesKey.length != 32) {
            this.logger.error("Fatal error trying to use AES key (wrong key length).");
            return true;
        }
        if (metaChannel.aesIV.length != 12) {
            this.logger.error("Fatal error trying to use AES IV (wrong IV length).");
            return true;
        }
        return false;
    }

    final void upgradeDecoders(Channel channel, MetaChannel metaChannel) {
        ChannelPipeline pipeline = channel.pipeline();
        try {
            if (metaChannel.tcpChannel == channel) {
                pipeline.replace(FRAME_AND_KRYO_DECODER, FRAME_AND_KRYO_CRYPTO_DECODER, (ChannelHandler)new KryoDecoderCrypto(this.serializationManager));
            }
            if (metaChannel.udpChannel == channel) {
                pipeline.replace(KRYO_DECODER, KRYO_CRYPTO_DECODER, (ChannelHandler)this.registrationWrapper.kryoUdpDecoderCrypto);
            }
        }
        catch (Exception e) {
            this.logger.error("Error during connection pipeline upgrade", (Throwable)e);
        }
    }

    final void upgradeEncoders(Channel channel, MetaChannel metaChannel, InetSocketAddress remoteAddress) {
        ChannelPipeline pipeline = channel.pipeline();
        try {
            if (metaChannel.tcpChannel == channel) {
                pipeline.replace(FRAME_AND_KRYO_ENCODER, FRAME_AND_KRYO_CRYPTO_ENCODER, (ChannelHandler)this.registrationWrapper.kryoTcpEncoderCrypto);
            }
            if (metaChannel.udpChannel == channel) {
                pipeline.replace(KRYO_ENCODER, KRYO_CRYPTO_ENCODER, (ChannelHandler)this.registrationWrapper.kryoUdpEncoderCrypto);
            }
        }
        catch (Exception e) {
            this.logger.error("Error during connection pipeline upgrade", (Throwable)e);
        }
    }

    final void upgradePipeline(MetaChannel metaChannel, InetSocketAddress remoteAddress) {
        this.logger.trace("Upgrading pipeline");
        try {
            ChannelPipeline pipeline;
            if (metaChannel.udpChannel == null || metaChannel.tcpChannel == null) {
                // empty if block
            }
            ConnectionImpl connection = this.registrationWrapper.connection0(metaChannel, remoteAddress);
            metaChannel.connection = new ConnectionWrapper(connection);
            if (metaChannel.tcpChannel != null) {
                pipeline = metaChannel.tcpChannel.pipeline();
                pipeline.addLast("connection", metaChannel.connection);
            }
            if (metaChannel.udpChannel != null) {
                pipeline = metaChannel.udpChannel.pipeline();
                pipeline.addLast("connection", metaChannel.connection);
            }
            if (this.logger.isInfoEnabled()) {
                StringBuilder stringBuilder = new StringBuilder(96);
                if (metaChannel.tcpChannel != null) {
                    stringBuilder.append("Encrypted TCP connection  [");
                    EndPoint.getHostDetails(stringBuilder, metaChannel.tcpChannel.localAddress());
                    stringBuilder.append(this.getConnectionDirection());
                    EndPoint.getHostDetails(stringBuilder, metaChannel.tcpChannel.remoteAddress());
                    stringBuilder.append("]");
                }
                if (metaChannel.udpChannel != null) {
                    stringBuilder.append("Encrypted UDP connection  [");
                    EndPoint.getHostDetails(stringBuilder, metaChannel.udpChannel.localAddress());
                    stringBuilder.append(this.getConnectionDirection());
                    EndPoint.getHostDetails(stringBuilder, metaChannel.udpChannel.remoteAddress());
                    stringBuilder.append("]");
                }
                this.logger.info(stringBuilder.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("Error during connection pipeline upgrade", (Throwable)e);
        }
    }

    final void cleanupPipeline(final MetaChannel metaChannel, final Runnable onConnectFinishRunnable) {
        int idleTimeout = this.registrationWrapper.getIdleTimeout();
        try {
            metaChannel.connection = ((ConnectionWrapper)metaChannel.connection).connection;
            ConnectionImpl handler = metaChannel.connection;
            Channel channel = metaChannel.tcpChannel != null ? metaChannel.tcpChannel : metaChannel.udpChannel;
            final ChannelPromise channelPromise = channel.newPromise();
            channelPromise.addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    EventLoop loop = channelPromise.channel().eventLoop();
                    loop.execute(new Runnable(){

                        @Override
                        public void run() {
                            RegistrationRemoteHandler.this.logger.trace("Notify Connection");
                            RegistrationRemoteHandler.this.registrationWrapper.connectionConnected0((ConnectionImpl)metaChannel.connection);
                            onConnectFinishRunnable.run();
                        }
                    });
                }
            });
            if (metaChannel.tcpChannel != null) {
                this.cleanupPipeline0(idleTimeout, (ChannelHandler)handler, metaChannel.tcpChannel, channelPromise, true);
            }
            if (metaChannel.udpChannel != null) {
                this.cleanupPipeline0(idleTimeout, (ChannelHandler)handler, metaChannel.udpChannel, channelPromise, false);
            }
        }
        catch (Exception e) {
            this.logger.error("Error during pipeline replace", (Throwable)e);
        }
    }

    private void cleanupPipeline0(int idleTimeout, ChannelHandler connection, final Channel channel, final ChannelPromise channelPromise, boolean isTcp) {
        ChannelPipeline pipeline = channel.pipeline();
        boolean isClient = this.registrationWrapper.isClient();
        if (isClient) {
            if (isTcp) {
                pipeline.remove(RegistrationRemoteHandlerClientTCP.class);
            } else {
                pipeline.remove(RegistrationRemoteHandlerClientUDP.class);
            }
        } else if (isTcp) {
            pipeline.remove(RegistrationRemoteHandlerServerTCP.class);
        } else {
            pipeline.remove(RegistrationRemoteHandlerServerUDP.class);
        }
        pipeline.remove(ConnectionWrapper.class);
        if (idleTimeout > 0) {
            pipeline.replace(IDLE_HANDLER, IDLE_HANDLER_FULL, (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
        } else {
            pipeline.remove(IDLE_HANDLER);
        }
        pipeline.addLast("connection", connection);
        ChannelFuture future = channel.deregister();
        future.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> f) throws Exception {
                if (f.isSuccess()) {
                    if (channelPromise.channel() == channel) {
                        RegistrationRemoteHandler.this.workerEventLoop.register(channelPromise);
                    } else {
                        RegistrationRemoteHandler.this.workerEventLoop.register(channel);
                    }
                }
            }
        });
    }

    boolean invalidPublicKey(Registration message, String type) {
        if (message.publicKey == null) {
            this.logger.error("Null ECC public key during " + type + " handshake. This shouldn't happen!");
            return true;
        }
        return false;
    }

    boolean invalidRemoteAddress(MetaChannel metaChannel, Registration message, String type, InetSocketAddress remoteAddress) {
        boolean valid = this.registrationWrapper.validateRemoteAddress(metaChannel, remoteAddress, message.publicKey);
        if (!valid) {
            String hostAddress = remoteAddress.getAddress().getHostAddress();
            this.logger.error("Invalid ECC public key for server IP {} during {} handshake. WARNING. The server has changed!", (Object)hostAddress, (Object)type);
            this.logger.error("Fix by adding the argument   -D{} {}   when starting the client.", (Object)DELETE_IP, (Object)hostAddress);
            return true;
        }
        return false;
    }

    void prepChannelForOutOfOrderMessages(Channel channel) {
        channel.attr(MESSAGES).setIfAbsent(new LinkedList());
    }

    void saveOutOfOrderMessage(Channel channel, Object message) {
        LinkedList list = (LinkedList)channel.attr(MESSAGES).get();
        if (list == null) {
            this.logger.error("Completely screwed up message order from server!");
            this.shutdown(channel, 0);
            return;
        }
        list.add(message);
    }

    List<Object> getOutOfOrderMessagesAndReset(Channel channel) {
        LinkedList messages = (LinkedList)channel.attr(MESSAGES).getAndSet(null);
        return messages;
    }
}

