/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandler;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.exceptions.SecurityException;
import dorkbox.util.serialization.EccPublicKeySerializer;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class RegistrationRemoteHandlerClient
extends RegistrationRemoteHandler {
    RegistrationRemoteHandlerClient(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
        String ipAsString = System.getProperty("eleteIP");
        if (ipAsString != null) {
            byte[] address;
            block8: {
                System.setProperty("eleteIP", "");
                address = null;
                try {
                    String[] split = ipAsString.split("\\.");
                    if (split.length != 4) break block8;
                    address = new byte[4];
                    for (int i = 0; i < split.length; ++i) {
                        int asInt = Integer.parseInt(split[i]);
                        if (asInt < 0 || asInt > 255) {
                            address = null;
                            break;
                        }
                        address[i] = (byte)Integer.parseInt(split[i]);
                    }
                }
                catch (Exception e) {
                    address = null;
                }
            }
            if (address != null) {
                try {
                    registrationWrapper.removeRegisteredServerKey(address);
                }
                catch (SecurityException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getConnectionDirection() {
        return " ==> ";
    }

    void readClient(Channel channel, Registration registration, String type, final MetaChannel metaChannel) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (metaChannel.aesKey == null && registration.publicKey != null) {
            if (this.invalidPublicKey(registration, type)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            if (this.invalidRemoteAddress(metaChannel, registration, type, remoteAddress)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            metaChannel.publicKey = registration.publicKey;
            metaChannel.ecdhKey = CryptoECC.generateKeyPair(eccSpec, this.registrationWrapper.getSecureRandom());
            Registration outboundRegister = new Registration(metaChannel.sessionId);
            Output output = new Output(1024);
            EccPublicKeySerializer.write(output, (ECPublicKeyParameters)metaChannel.ecdhKey.getPublic());
            outboundRegister.payload = output.toBytes();
            channel.writeAndFlush((Object)outboundRegister);
            return;
        }
        if (metaChannel.aesKey == null) {
            ECPublicKeyParameters ecdhPubKey;
            byte[] ecdhPubKeyBytes = Arrays.copyOfRange(registration.payload, 0, registration.payload.length);
            try {
                ecdhPubKey = EccPublicKeySerializer.read(new Input(ecdhPubKeyBytes));
            }
            catch (KryoException e) {
                this.logger.error("Invalid decode of ECDH public key. Aborting.");
                this.shutdown(channel, registration.sessionID);
                return;
            }
            ECDHCBasicAgreement agreement = new ECDHCBasicAgreement();
            agreement.init((CipherParameters)metaChannel.ecdhKey.getPrivate());
            BigInteger shared = agreement.calculateAgreement((CipherParameters)ecdhPubKey);
            byte[] keySeed = shared.toByteArray();
            SHA384Digest sha384 = new SHA384Digest();
            byte[] digest = new byte[sha384.getDigestSize()];
            sha384.update(keySeed, 0, keySeed.length);
            sha384.doFinal(digest, 0);
            metaChannel.aesKey = Arrays.copyOfRange(digest, 0, 32);
            metaChannel.aesIV = Arrays.copyOfRange(digest, 32, 44);
            if (this.invalidAES(metaChannel)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            Registration outboundRegister = new Registration(metaChannel.sessionId);
            outboundRegister.hasMore = this.registrationWrapper.hasMoreRegistrations();
            channel.writeAndFlush((Object)outboundRegister);
            return;
        }
        if (registration.upgrade) {
            this.upgradeEncoders(channel, metaChannel, remoteAddress);
            this.upgradeDecoders(channel, metaChannel);
        }
        if (registration.hasMore) {
            this.logger.trace("Starting another protocol registration");
            metaChannel.totalProtocols.incrementAndGet();
            this.registrationWrapper.startNextProtocolRegistration();
            return;
        }
        if (!registration.upgraded) {
            this.upgradePipeline(metaChannel, remoteAddress);
            registration.upgraded = true;
            channel.writeAndFlush((Object)registration);
            return;
        }
        int protocolsRemaining = metaChannel.totalProtocols.decrementAndGet();
        if (protocolsRemaining > 0) {
            this.logger.trace("{} done. Waiting for {} more protocols registrations to arrive...", (Object)type, (Object)protocolsRemaining);
            return;
        }
        this.cleanupPipeline(metaChannel, new Runnable(){

            @Override
            public void run() {
                List<Object> list;
                LinkedList<Object> messages = new LinkedList<Object>();
                if (metaChannel.tcpChannel != null && (list = RegistrationRemoteHandlerClient.this.getOutOfOrderMessagesAndReset(metaChannel.tcpChannel)) != null) {
                    RegistrationRemoteHandlerClient.this.logger.trace("Getting deferred TCP messages: {}", (Object)list.size());
                    messages.addAll(list);
                }
                if (metaChannel.udpChannel != null && (list = RegistrationRemoteHandlerClient.this.getOutOfOrderMessagesAndReset(metaChannel.udpChannel)) != null) {
                    RegistrationRemoteHandlerClient.this.logger.trace("Getting deferred UDP messages: {}", (Object)list.size());
                    messages.addAll(list);
                }
                try {
                    ConnectionImpl connection = (ConnectionImpl)metaChannel.connection;
                    for (Object e : messages) {
                        RegistrationRemoteHandlerClient.this.logger.trace("    deferred onMessage({}, {})", (Object)connection.id(), e);
                        try {
                            connection.channelRead(null, e);
                        }
                        catch (Exception e2) {
                            RegistrationRemoteHandlerClient.this.logger.error("Error running deferred messages!", (Throwable)e2);
                        }
                    }
                }
                catch (Exception e) {
                    RegistrationRemoteHandlerClient.this.logger.error("Error initialising deferred messages!", (Throwable)e);
                }
            }
        });
    }
}

