/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;

public class RegistrationRemoteHandlerClientTCP
extends RegistrationRemoteHandlerClient {
    public RegistrationRemoteHandlerClientTCP(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        this.logger.trace("Start new TCP Connection. Sending request to server");
        Registration registration = new Registration(0);
        registration.publicKey = this.registrationWrapper.getPublicKey();
        context.channel().writeAndFlush((Object)registration);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        if (message instanceof Registration) {
            Registration registration = (Registration)message;
            int sessionId = registration.sessionID;
            if (sessionId == 0) {
                this.logger.error("Invalid TCP channel session ID 0!");
                this.shutdown(channel, 0);
                return;
            }
            MetaChannel metaChannel = this.registrationWrapper.getSession(sessionId);
            if (metaChannel == null) {
                metaChannel = this.registrationWrapper.createSessionClient(sessionId);
                metaChannel.tcpChannel = channel;
                this.logger.debug("New TCP connection. Saving meta-channel id: {}", (Object)metaChannel.sessionId);
            }
            this.prepChannelForOutOfOrderMessages(channel);
            this.logger.trace("TCP read");
            this.readClient(channel, registration, "TCP client", metaChannel);
        } else {
            this.logger.trace("Out of order TCP message from server!");
            this.saveOutOfOrderMessage(channel, message);
        }
    }
}

