/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;

public class RegistrationRemoteHandlerClientUDP
extends RegistrationRemoteHandlerClient {
    public RegistrationRemoteHandlerClientUDP(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        Registration outboundRegister;
        super.channelActive(context);
        Channel channel = context.channel();
        InetSocketAddress udpRemoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (udpRemoteAddress != null) {
            outboundRegister = new Registration(0);
            outboundRegister.publicKey = this.registrationWrapper.getPublicKey();
            MetaChannel firstSession = this.registrationWrapper.getFirstSession();
            if (firstSession != null) {
                outboundRegister.sessionID = firstSession.sessionId;
                outboundRegister.hasMore = this.registrationWrapper.hasMoreRegistrations();
            }
        } else {
            throw new IOException("UDP cannot connect to remote server! No remote address specified!");
        }
        channel.writeAndFlush((Object)outboundRegister);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        if (message instanceof Registration) {
            Registration registration = (Registration)message;
            int sessionId = registration.sessionID;
            if (sessionId == 0) {
                this.logger.error("Invalid UDP channel session ID 0!");
                return;
            }
            MetaChannel metaChannel = this.registrationWrapper.getSession(sessionId);
            if (metaChannel == null) {
                metaChannel = this.registrationWrapper.createSessionClient(sessionId);
                this.logger.debug("New UDP connection. Saving meta-channel id: {}", (Object)metaChannel.sessionId);
            } else if (metaChannel.udpChannel == null) {
                this.logger.debug("Using TCP connection meta-channel for UDP connection");
            }
            metaChannel.udpChannel = channel;
            this.prepChannelForOutOfOrderMessages(channel);
            this.readClient(channel, registration, "UDP client", metaChannel);
        } else {
            this.logger.trace("Out of order UDP message from server!");
            this.saveOutOfOrderMessage(channel, message);
        }
    }
}

