/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandler;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.serialization.EccPublicKeySerializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.util.Arrays;

public class RegistrationRemoteHandlerServer
extends RegistrationRemoteHandler {
    private static final long ECDH_TIMEOUT = TimeUnit.MINUTES.toNanos(10L);
    private static final ECParameterSpec eccSpec = ECNamedCurveTable.getParameterSpec((String)"curve25519");
    private final Object ecdhKeyLock = new Object();
    private AsymmetricCipherKeyPair ecdhKeyPair;
    private volatile long ecdhTimeout = System.nanoTime();

    RegistrationRemoteHandlerServer(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
    }

    @Override
    protected String getConnectionDirection() {
        return " <== ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsymmetricCipherKeyPair getEchdKeyOnRotate(SecureRandom secureRandom) {
        if (this.ecdhKeyPair == null || System.nanoTime() - this.ecdhTimeout > ECDH_TIMEOUT) {
            Object object = this.ecdhKeyLock;
            synchronized (object) {
                this.ecdhTimeout = System.nanoTime();
                this.ecdhKeyPair = CryptoECC.generateKeyPair(eccSpec, secureRandom);
            }
        }
        return this.ecdhKeyPair;
    }

    void readServer(ChannelHandlerContext context, Channel channel, final Registration registration, String type, final MetaChannel metaChannel) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (registration.sessionID == 0) {
            if (this.invalidPublicKey(registration, type)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            if (this.invalidRemoteAddress(metaChannel, registration, type, remoteAddress)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            metaChannel.publicKey = registration.publicKey;
            Registration outboundRegister = new Registration(metaChannel.sessionId);
            outboundRegister.publicKey = this.registrationWrapper.getPublicKey();
            outboundRegister.eccParameters = CryptoECC.generateSharedParameters(this.registrationWrapper.getSecureRandom());
            channel.writeAndFlush((Object)outboundRegister);
            return;
        }
        if (metaChannel.aesKey == null) {
            ECPublicKeyParameters ecdhPubKey;
            metaChannel.ecdhKey = this.getEchdKeyOnRotate(this.registrationWrapper.getSecureRandom());
            byte[] ecdhPubKeyBytes = java.util.Arrays.copyOfRange(registration.payload, 0, registration.payload.length);
            try {
                ecdhPubKey = EccPublicKeySerializer.read(new Input(ecdhPubKeyBytes));
            }
            catch (KryoException e) {
                this.logger.error("Invalid decode of ECDH public key. Aborting.");
                this.shutdown(channel, registration.sessionID);
                return;
            }
            ECDHCBasicAgreement agreement = new ECDHCBasicAgreement();
            agreement.init((CipherParameters)metaChannel.ecdhKey.getPrivate());
            BigInteger shared = agreement.calculateAgreement((CipherParameters)ecdhPubKey);
            byte[] keySeed = shared.toByteArray();
            SHA384Digest sha384 = new SHA384Digest();
            byte[] digest = new byte[sha384.getDigestSize()];
            sha384.update(keySeed, 0, keySeed.length);
            sha384.doFinal(digest, 0);
            metaChannel.aesKey = Arrays.copyOfRange((byte[])digest, (int)0, (int)32);
            metaChannel.aesIV = Arrays.copyOfRange((byte[])digest, (int)32, (int)44);
            if (this.invalidAES(metaChannel)) {
                this.shutdown(channel, registration.sessionID);
                return;
            }
            Registration outboundRegister = new Registration(metaChannel.sessionId);
            Output output = new Output(1024);
            EccPublicKeySerializer.write(output, (ECPublicKeyParameters)metaChannel.ecdhKey.getPublic());
            outboundRegister.payload = output.toBytes();
            channel.writeAndFlush((Object)outboundRegister);
            return;
        }
        if (!registration.upgraded) {
            registration.upgrade = true;
            this.upgradeDecoders(channel, metaChannel);
            channel.write((Object)registration);
            this.upgradeEncoders(channel, metaChannel, remoteAddress);
            if (!registration.hasMore) {
                this.upgradePipeline(metaChannel, remoteAddress);
            }
            channel.flush();
            return;
        }
        this.cleanupPipeline(metaChannel, new Runnable(){

            @Override
            public void run() {
                Registration reg;
                if (metaChannel.tcpChannel != null) {
                    RegistrationRemoteHandlerServer.this.logger.trace("Sending TCP upgraded command");
                    reg = new Registration(registration.sessionID);
                    reg.upgraded = true;
                    metaChannel.tcpChannel.writeAndFlush((Object)reg);
                }
                if (metaChannel.udpChannel != null) {
                    RegistrationRemoteHandlerServer.this.logger.trace("Sending UDP upgraded command");
                    reg = new Registration(registration.sessionID);
                    reg.upgraded = true;
                    metaChannel.udpChannel.writeAndFlush((Object)reg);
                }
            }
        });
    }
}

