/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;

public class RegistrationRemoteHandlerServerTCP
extends RegistrationRemoteHandlerServer {
    public RegistrationRemoteHandlerServerTCP(String name, RegistrationWrapper registrationWrapper, EventLoopGroup workerEventLoop) {
        super(name, registrationWrapper, workerEventLoop);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        if (message instanceof Registration) {
            MetaChannel metaChannel;
            Registration registration = (Registration)message;
            int sessionId = registration.sessionID;
            if (sessionId == 0) {
                metaChannel = this.registrationWrapper.createSessionServer();
                metaChannel.tcpChannel = channel;
                this.logger.debug("New TCP connection. Saving meta-channel id: {}", (Object)metaChannel.sessionId);
            } else {
                metaChannel = this.registrationWrapper.getSession(sessionId);
                if (metaChannel == null) {
                    this.logger.error("Error getting invalid TCP channel session ID {}! MetaChannel is null!", (Object)sessionId);
                    this.shutdown(channel, sessionId);
                    return;
                }
            }
            this.readServer(context, channel, registration, "TCP server", metaChannel);
        } else {
            this.logger.error("Error registering TCP with remote client!");
            ChannelHandler connection = context.pipeline().last();
            if (connection instanceof ConnectionImpl) {
                ((ConnectionImpl)connection).channelRead(context, message);
            } else {
                this.shutdown(channel, 0);
            }
        }
    }
}

