/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.rmi.RmiObjectHandler;
import io.netty.channel.Channel;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ChannelLocalWrapper
implements ChannelWrapper,
ConnectionPoint {
    private final Channel channel;
    private final RmiObjectHandler rmiObjectHandler;
    private final AtomicBoolean shouldFlush = new AtomicBoolean(false);
    private String remoteAddress;

    public ChannelLocalWrapper(MetaChannel metaChannel, RmiObjectHandler rmiObjectHandler) {
        this.channel = metaChannel.localChannel;
        this.rmiObjectHandler = rmiObjectHandler;
        this.remoteAddress = ((LocalAddress)this.channel.remoteAddress()).id();
    }

    @Override
    public void write(Object object) {
        this.channel.write(object);
        this.shouldFlush.set(true);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public ConnectionPoint tcp() {
        return this;
    }

    @Override
    public ConnectionPoint udp() {
        return this;
    }

    @Override
    public void flush() {
        if (this.shouldFlush.compareAndSet(true, false)) {
            this.channel.flush();
        }
    }

    @Override
    public <V> Promise<V> newPromise() {
        return this.channel.eventLoop().newPromise();
    }

    @Override
    public ParametersWithIV cryptoParameters() {
        return null;
    }

    @Override
    public boolean isLoopback() {
        return true;
    }

    @Override
    public RmiObjectHandler manageRmi() {
        return this.rmiObjectHandler;
    }

    @Override
    public final String getRemoteHost() {
        return this.remoteAddress;
    }

    @Override
    public void close(ConnectionImpl connection, ISessionManager sessionManager, boolean hintedClose) {
        long maxShutdownWaitTimeInMilliSeconds = EndPoint.maxShutdownWaitTimeInMilliSeconds;
        this.shouldFlush.set(false);
        this.channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
    }

    @Override
    public int id() {
        return this.channel.hashCode();
    }

    public int hashCode() {
        return this.channel.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelLocalWrapper other = (ChannelLocalWrapper)obj;
        return !(this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress));
    }
}

