/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.ConnectionPoint;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChannelNetwork
implements ConnectionPoint {
    final Channel channel;
    final AtomicBoolean shouldFlush = new AtomicBoolean(false);
    private final ChannelPromise voidPromise;

    public ChannelNetwork(Channel channel) {
        this.channel = channel;
        this.voidPromise = channel.voidPromise();
    }

    @Override
    public void write(Object object) throws Exception {
        this.shouldFlush.set(true);
        this.channel.write(object, this.voidPromise);
    }

    @Override
    public boolean isWritable() {
        return this.channel.isWritable();
    }

    @Override
    public void flush() {
        if (this.shouldFlush.compareAndSet(true, false)) {
            this.channel.flush();
        }
    }

    @Override
    public <V> Promise<V> newPromise() {
        return this.channel.eventLoop().newPromise();
    }

    void close(int delay, final long maxShutdownWaitTimeInMilliSeconds) {
        this.shouldFlush.set(false);
        if (this.channel.isActive()) {
            if (delay > 0) {
                this.channel.eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ChannelNetwork.this.channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                this.channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
            }
        }
    }
}

