/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelNetwork;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.rmi.RmiObjectHandler;
import dorkbox.util.FastThreadLocal;
import io.netty.bootstrap.DatagramCloseMessage;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ChannelNetworkWrapper
implements ChannelWrapper {
    private final int sessionId;
    private final ChannelNetwork tcp;
    private final ChannelNetwork udp;
    private final boolean remotePublicKeyChanged;
    private final String remoteAddress;
    private final boolean isLoopback;
    private final byte[] aesKey;
    private final byte[] aesIV;
    private final FastThreadLocal<ParametersWithIV> cryptoParameters;
    private final RmiObjectHandler rmiObjectHandler;

    public ChannelNetworkWrapper(MetaChannel metaChannel, InetSocketAddress remoteAddress, RmiObjectHandler rmiObjectHandler) {
        this.sessionId = metaChannel.sessionId;
        this.rmiObjectHandler = rmiObjectHandler;
        this.isLoopback = remoteAddress.getAddress().equals(NetUtil.LOCALHOST);
        this.tcp = metaChannel.tcpChannel != null ? new ChannelNetwork(metaChannel.tcpChannel) : null;
        this.udp = metaChannel.udpChannel != null ? new ChannelNetwork(metaChannel.udpChannel) : null;
        this.remoteAddress = remoteAddress.getAddress().getHostAddress();
        this.remotePublicKeyChanged = metaChannel.changedRemoteKey;
        this.aesKey = metaChannel.aesKey;
        this.aesIV = metaChannel.aesIV;
        this.cryptoParameters = new FastThreadLocal<ParametersWithIV>(){

            @Override
            public ParametersWithIV initialValue() {
                return new ParametersWithIV((CipherParameters)new KeyParameter(ChannelNetworkWrapper.this.aesKey), ChannelNetworkWrapper.this.aesIV);
            }
        };
    }

    public final boolean remoteKeyChanged() {
        return this.remotePublicKeyChanged;
    }

    @Override
    public ConnectionPoint tcp() {
        return this.tcp;
    }

    @Override
    public ConnectionPoint udp() {
        return this.udp;
    }

    @Override
    public void flush() {
        if (this.tcp != null) {
            this.tcp.flush();
        }
        if (this.udp != null) {
            this.udp.flush();
        }
    }

    @Override
    public ParametersWithIV cryptoParameters() {
        return this.cryptoParameters.get();
    }

    @Override
    public boolean isLoopback() {
        return this.isLoopback;
    }

    @Override
    public RmiObjectHandler manageRmi() {
        return this.rmiObjectHandler;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteAddress;
    }

    @Override
    public void close(ConnectionImpl connection, ISessionManager sessionManager, boolean hintedClose) {
        long maxShutdownWaitTimeInMilliSeconds = EndPoint.maxShutdownWaitTimeInMilliSeconds;
        if (this.tcp != null) {
            this.tcp.close(0, maxShutdownWaitTimeInMilliSeconds);
        }
        if (this.udp != null) {
            if (hintedClose) {
                this.udp.close(0, maxShutdownWaitTimeInMilliSeconds);
            } else {
                try {
                    this.udp.write(new DatagramCloseMessage());
                    this.udp.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.udp.close(200, maxShutdownWaitTimeInMilliSeconds);
            }
        }
        Thread.yield();
    }

    @Override
    public int id() {
        return this.sessionId;
    }

    public int hashCode() {
        return this.sessionId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelNetworkWrapper other = (ChannelNetworkWrapper)obj;
        return !(this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress));
    }

    @Override
    public String toString() {
        return "NetworkConnection [" + this.getRemoteHost() + "]";
    }
}

