/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import dorkbox.network.dns.exceptions.WireParseException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class DnsInput {
    private ByteBuf byteBuf;
    private int savedActiveIndex = -1;
    private boolean marked = false;

    public DnsInput(byte[] input) {
        this.byteBuf = Unpooled.wrappedBuffer((byte[])input);
    }

    public DnsInput(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public int readIndex() {
        return this.byteBuf.readerIndex();
    }

    public void setActive(int len) {
        this.savedActiveIndex = this.byteBuf.writerIndex();
        if (len > this.byteBuf.readableBytes()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuf.writerIndex(this.byteBuf.readerIndex() + len);
    }

    public void restoreActive() {
        if (this.savedActiveIndex > -1) {
            this.byteBuf.writerIndex(this.savedActiveIndex);
            this.savedActiveIndex = -1;
        }
    }

    public void jump(int index) {
        if (index >= this.byteBuf.capacity()) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.byteBuf.readerIndex(index);
        this.restoreActive();
    }

    public void save() {
        this.marked = true;
        this.byteBuf.markReaderIndex();
    }

    public void restore() {
        if (!this.marked) {
            throw new IllegalStateException("Not marked first");
        }
        this.byteBuf.resetReaderIndex();
    }

    private void require(int n) throws WireParseException {
        if (n > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public int remaining() {
        return this.byteBuf.readableBytes();
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.byteBuf.readUnsignedByte();
    }

    public int readU16() throws WireParseException {
        this.require(2);
        return this.byteBuf.readUnsignedShort();
    }

    public long readU32() throws WireParseException {
        this.require(4);
        return this.byteBuf.readUnsignedInt();
    }

    public void readByteArray(byte[] b, int off, int len) throws WireParseException {
        this.require(len);
        this.byteBuf.readBytes(b, off, len);
    }

    public byte[] readByteArray(int len) throws WireParseException {
        this.require(len);
        byte[] out = new byte[len];
        this.byteBuf.readBytes(out, 0, len);
        return out;
    }

    public byte[] readByteArray() {
        int len = this.remaining();
        byte[] out = new byte[len];
        this.byteBuf.readBytes(out, 0, len);
        return out;
    }

    public byte[] readCountedString() throws WireParseException {
        int len = this.readU8();
        return this.readByteArray(len);
    }
}

