/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import dorkbox.network.dns.DnsEnvelope;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.constants.Flags;
import dorkbox.network.dns.records.DnsRecord;
import io.netty.channel.AddressedEnvelope;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.util.Locale;

public class DnsQuestion
extends DnsEnvelope {
    private final boolean isResolveQuestion;

    public static DnsQuestion newResolveQuestion(String inetHost, int type, boolean isRecursionDesired) {
        return DnsQuestion.newQuestion(inetHost, type, isRecursionDesired, true);
    }

    public static DnsQuestion newQuery(String inetHost, int type, boolean isRecursionDesired) {
        return DnsQuestion.newQuestion(inetHost, type, isRecursionDesired, false);
    }

    public static Name createName(String hostName, int type) {
        if ((hostName = DnsQuestion.hostNameAsciiFix((String)ObjectUtil.checkNotNull((Object)hostName, (String)"hostname"))) == null) {
            return null;
        }
        hostName = hostName.toLowerCase(Locale.US);
        hostName = DnsRecordType.ensureFQDN(type, hostName);
        try {
            return Name.fromString(hostName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DnsQuestion newQuestion(String inetHost, int type, boolean isRecursionDesired, boolean isResolveQuestion) {
        Name name = DnsQuestion.createName(inetHost, type);
        try {
            DnsRecord questionRecord = DnsRecord.newRecord(name, type, 1);
            DnsQuestion question = new DnsQuestion(isResolveQuestion);
            question.getHeader().setOpcode(0);
            if (isRecursionDesired) {
                question.getHeader().setFlag(Flags.RD);
            }
            question.addRecord(questionRecord, 0);
            question.retain();
            return question;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hostNameAsciiFix(String inetHost) {
        try {
            String hostName = IDN.toASCII(inetHost);
            if (StringUtil.endsWith((CharSequence)inetHost, (char)'.') && !StringUtil.endsWith((CharSequence)hostName, (char)'.')) {
                return hostName + '.';
            }
            return hostName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private DnsQuestion(boolean isResolveQuestion) {
        this.isResolveQuestion = isResolveQuestion;
    }

    public boolean isResolveQuestion() {
        return this.isResolveQuestion;
    }

    public void init(int id, InetSocketAddress recipient) {
        this.getHeader().setID(id);
        this.setRemoteAddress(recipient);
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.sender() != null) {
            hashCode = hashCode * 31 + this.sender().hashCode();
        }
        if (this.recipient() != null) {
            hashCode = hashCode * 31 + this.recipient().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AddressedEnvelope)) {
            return false;
        }
        AddressedEnvelope that = (AddressedEnvelope)obj;
        if (this.sender() == null ? that.sender() != null : !this.sender().equals(that.sender())) {
            return false;
        }
        return !(this.recipient() == null ? that.recipient() != null : !this.recipient().equals(that.recipient()));
    }
}

