/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.constants;

import dorkbox.network.dns.Mnemonic;
import dorkbox.network.dns.exceptions.InvalidTypeException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.DnsTypeProtoAssignment;
import dorkbox.util.collections.IntMap;
import io.netty.util.internal.StringUtil;

public final class DnsRecordType {
    public static final int A = 1;
    public static final int NS = 2;
    @Deprecated
    public static final int MD = 3;
    @Deprecated
    public static final int MF = 4;
    public static final int CNAME = 5;
    public static final int SOA = 6;
    public static final int MB = 7;
    public static final int MG = 8;
    public static final int MR = 9;
    public static final int NULL = 10;
    public static final int WKS = 11;
    public static final int PTR = 12;
    public static final int HINFO = 13;
    public static final int MINFO = 14;
    public static final int MX = 15;
    public static final int TXT = 16;
    public static final int RP = 17;
    public static final int AFSDB = 18;
    public static final int X25 = 19;
    public static final int ISDN = 20;
    public static final int RT = 21;
    public static final int NSAP = 22;
    @Deprecated
    public static final int NSAP_PTR = 23;
    public static final int SIG = 24;
    public static final int KEY = 25;
    public static final int PX = 26;
    @Deprecated
    public static final int GPOS = 27;
    public static final int AAAA = 28;
    public static final int LOC = 29;
    public static final int NXT = 30;
    public static final int EID = 31;
    public static final int NIMLOC = 32;
    public static final int SRV = 33;
    public static final int ATMA = 34;
    public static final int NAPTR = 35;
    public static final int KX = 36;
    public static final int CERT = 37;
    public static final int A6 = 38;
    public static final int DNAME = 39;
    public static final int OPT = 41;
    public static final int APL = 42;
    public static final int DS = 43;
    public static final int SSHFP = 44;
    public static final int IPSECKEY = 45;
    public static final int RRSIG = 46;
    public static final int NSEC = 47;
    public static final int DNSKEY = 48;
    public static final int DHCID = 49;
    public static final int NSEC3 = 50;
    public static final int NSEC3PARAM = 51;
    public static final int TLSA = 52;
    public static final int SMIMEA = 53;
    public static final int HIP = 55;
    public static final int OPENPGPKEY = 61;
    public static final int SPF = 99;
    public static final int TKEY = 249;
    public static final int TSIG = 250;
    public static final int IXFR = 251;
    public static final int AXFR = 252;
    public static final int MAILB = 253;
    public static final int MAILA = 254;
    public static final int ANY = 255;
    public static final int URI = 256;
    public static final int CAA = 257;
    public static final int TA = 32768;
    public static final int DLV = 32769;
    private static TypeMnemonic types = new TypeMnemonic();
    private static final String ptrSuffix = ".in-addr.arpa";

    private DnsRecordType() {
    }

    public static void check(int val) {
        if (val < 0 || val > 65535) {
            throw new InvalidTypeException(val);
        }
    }

    public static String string(int val) {
        return types.getText(val);
    }

    public static int value(String s) {
        return DnsRecordType.value(s, false);
    }

    public static int value(String s, boolean numberok) {
        int val = types.getValue(s);
        if (val == -1 && numberok) {
            val = types.getValue("TYPE" + s);
        }
        return val;
    }

    public static <T extends DnsRecord> T getProto(int val) {
        return types.getProto(val);
    }

    public static boolean isRR(int type) {
        switch (type) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    public static String ensureFQDN(int type, String hostName) {
        switch (type) {
            case 12: {
                if (!hostName.endsWith(ptrSuffix)) {
                    return hostName + ptrSuffix;
                }
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 99: 
            case 257: {
                if (!StringUtil.endsWith((CharSequence)hostName, (char)'.')) {
                    return hostName + '.';
                }
                return hostName;
            }
        }
        return hostName;
    }

    static {
        DnsTypeProtoAssignment.assign(types);
    }

    public static class TypeMnemonic
    extends Mnemonic {
        private IntMap<DnsRecord> objects;

        public TypeMnemonic() {
            super("DnsRecordType", 2);
            this.setPrefix("TYPE");
            this.objects = new IntMap();
        }

        public void add(int value, String str, DnsRecord proto) {
            super.add(value, str);
            this.objects.put(value, proto);
        }

        public <T extends DnsRecord> T getProto(int value) {
            this.check(value);
            return (T)this.objects.get(value);
        }

        @Override
        public void check(int val) {
            DnsRecordType.check(val);
        }
    }
}

