/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.constants;

import dorkbox.network.dns.Mnemonic;

public enum ExtendedFlags {
    DO(32768, "do");

    private static Mnemonic extflags;
    private final byte flagValue;
    private final String textValue;

    private ExtendedFlags(int flagValue, String textValue) {
        this.flagValue = (byte)flagValue;
        this.textValue = textValue;
    }

    public byte value() {
        return this.flagValue;
    }

    public String string() {
        return this.textValue;
    }

    public static String string(int i) {
        return extflags.getText(i);
    }

    public static int value(String s) {
        return extflags.getValue(s);
    }

    static {
        extflags = new Mnemonic("EDNS Flag", 3);
        extflags.setMaximum(65535);
        extflags.setPrefix("FLAG");
        extflags.setNumericAllowed(true);
        extflags.add(ExtendedFlags.DO.flagValue, "do");
    }
}

