/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.constants;

import dorkbox.network.dns.Mnemonic;
import dorkbox.network.dns.constants.ExtendedFlags;

public enum Flags {
    QR(0, "qr"),
    AA(5, "aa"),
    TC(6, "tc"),
    RD(7, "rd"),
    RA(8, "ra"),
    RESERVED(9, "__"),
    AD(10, "ad"),
    CD(11, "cd"),
    DO(ExtendedFlags.DO.value(), ExtendedFlags.DO.string());

    private static Mnemonic flags;
    private final byte flagValue;
    private final String textValue;

    private Flags(int flagValue, String textValue) {
        this.flagValue = (byte)flagValue;
        this.textValue = textValue;
    }

    public byte value() {
        return this.flagValue;
    }

    public String string() {
        return this.textValue;
    }

    public static Flags toFlag(int flagBit) {
        for (Flags flag : Flags.values()) {
            if (flag.value() != flagBit) continue;
            return flag;
        }
        throw new IllegalArgumentException("Invalid flag " + flagBit);
    }

    public static Flags toFlag(String flagName) {
        for (Flags flag : Flags.values()) {
            if (!flag.string().equals(flagName)) continue;
            return flag;
        }
        throw new IllegalArgumentException("Invalid flag " + flagName);
    }

    public static boolean isFlag(int index) {
        return index >= 0 && index <= 15 && (index < 1 || index > 4) && index < 12;
    }

    static {
        flags = new Mnemonic("DNS Header Flag", 3);
        flags.setMaximum(15);
        flags.setPrefix("FLAG");
        flags.setNumericAllowed(true);
        flags.add(Flags.QR.flagValue, "qr");
        flags.add(Flags.AA.flagValue, "aa");
        flags.add(Flags.TC.flagValue, "tc");
        flags.add(Flags.RD.flagValue, "rd");
        flags.add(Flags.RA.flagValue, "ra");
        flags.add(Flags.AD.flagValue, "ad");
        flags.add(Flags.CD.flagValue, "cd");
    }
}

