/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Address;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AAAARecord
extends DnsRecord {
    private static final long serialVersionUID = -4588601512069748050L;
    private byte[] address;

    AAAARecord() {
    }

    @Override
    DnsRecord getObject() {
        return new AAAARecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.address = in.readByteArray(16);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }

    @Override
    void rrToString(StringBuilder sb) {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException e) {
            return;
        }
        if (addr.getAddress().length == 4) {
            sb.append("0:0:0:0:0:ffff:");
            int high = ((this.address[12] & 0xFF) << 8) + (this.address[13] & 0xFF);
            int low = ((this.address[14] & 0xFF) << 8) + (this.address[15] & 0xFF);
            sb.append(Integer.toHexString(high));
            sb.append(':');
            sb.append(Integer.toHexString(low));
            return;
        }
        sb.append(addr.getHostAddress());
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.address = st.getAddressBytes(2);
    }

    public AAAARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 28, dclass, ttl);
        if (Address.familyOf(address) != 2) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.address = address.getAddress();
    }

    public AAAARecord(Name name, int dclass, long ttl, byte[] address) {
        super(name, 28, dclass, ttl);
        if (address.length != Address.addressLength(2)) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.address = address;
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(this.address);
            }
            return InetAddress.getByAddress(this.name.toString(true), this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

