/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Address;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ARecord
extends DnsRecord {
    private static final long serialVersionUID = -2172609200849142323L;
    private int addr;

    ARecord() {
    }

    @Override
    DnsRecord getObject() {
        return new ARecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.addr = ARecord.fromArray(in.readByteArray(4));
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU32((long)this.addr & 0xFFFFFFFFL);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(Address.toDottedQuad(ARecord.toArray(this.addr)));
    }

    private static byte[] toArray(int addr) {
        byte[] bytes = new byte[]{(byte)(addr >>> 24 & 0xFF), (byte)(addr >>> 16 & 0xFF), (byte)(addr >>> 8 & 0xFF), (byte)(addr & 0xFF)};
        return bytes;
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.addr = ARecord.fromArray(st.getAddressBytes(1));
    }

    private static int fromArray(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 1, dclass, ttl);
        if (Address.familyOf(address) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(address.getAddress());
    }

    public ARecord(Name name, int dclass, long ttl, byte[] address) {
        super(name, 1, dclass, ttl);
        if (address.length != Address.addressLength(1)) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(address);
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(ARecord.toArray(this.addr));
            }
            return InetAddress.getByAddress(this.name.toString(true), ARecord.toArray(this.addr));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

