/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class CAARecord
extends DnsRecord {
    private static final long serialVersionUID = 8544304287274216443L;
    private int flags;
    private byte[] tag;
    private byte[] value;

    CAARecord() {
    }

    @Override
    DnsRecord getObject() {
        return new CAARecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.flags = in.readU8();
        this.tag = in.readCountedString();
        this.value = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU8(this.flags);
        out.writeCountedString(this.tag);
        out.writeByteArray(this.value);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.flags);
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.tag, false));
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.value, true));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.flags = st.getUInt8();
        try {
            this.tag = CAARecord.byteArrayFromString(st.getString());
            this.value = CAARecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public CAARecord(Name name, int dclass, long ttl, int flags, String tag, String value) {
        super(name, 257, dclass, ttl);
        this.flags = CAARecord.checkU8("flags", flags);
        try {
            this.tag = CAARecord.byteArrayFromString(tag);
            this.value = CAARecord.byteArrayFromString(value);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public String getTag() {
        return CAARecord.byteArrayToString(this.tag, false);
    }

    public String getValue() {
        return CAARecord.byteArrayToString(this.value, false);
    }

    public static class Flags {
        public static final int IssuerCritical = 128;

        private Flags() {
        }
    }
}

