/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.EDNSOption;
import dorkbox.network.dns.utils.base16;
import java.io.IOException;

public class GenericEDNSOption
extends EDNSOption {
    private byte[] data;

    GenericEDNSOption(int code) {
        super(code);
    }

    public GenericEDNSOption(int code, byte[] data) {
        super(code);
        this.data = DnsRecord.checkByteArrayLength("option data", data, 65535);
    }

    @Override
    void optionFromWire(DnsInput in) throws IOException {
        this.data = in.readByteArray();
    }

    @Override
    void optionToWire(DnsOutput out) {
        out.writeByteArray(this.data);
    }

    @Override
    String optionToString() {
        return "<" + base16.toString(this.data) + ">";
    }
}

