/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class HINFORecord
extends DnsRecord {
    private static final long serialVersionUID = -4732870630947452112L;
    private byte[] cpu;
    private byte[] os;

    HINFORecord() {
    }

    @Override
    DnsRecord getObject() {
        return new HINFORecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.cpu = in.readCountedString();
        this.os = in.readCountedString();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.cpu);
        out.writeCountedString(this.os);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(HINFORecord.byteArrayToString(this.cpu, true));
        sb.append(" ");
        sb.append(HINFORecord.byteArrayToString(this.os, true));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.cpu = HINFORecord.byteArrayFromString(st.getString());
            this.os = HINFORecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public HINFORecord(Name name, int dclass, long ttl, String cpu, String os) {
        super(name, 13, dclass, ttl);
        try {
            this.cpu = HINFORecord.byteArrayFromString(cpu);
            this.os = HINFORecord.byteArrayFromString(os);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String getCPU() {
        return HINFORecord.byteArrayToString(this.cpu, false);
    }

    public String getOS() {
        return HINFORecord.byteArrayToString(this.os, false);
    }
}

