/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.constants.DnsOpCode;
import dorkbox.network.dns.constants.DnsResponseCode;
import dorkbox.network.dns.constants.DnsSection;
import dorkbox.network.dns.constants.Flags;
import dorkbox.util.FastThreadLocal;
import dorkbox.util.MersenneTwisterFast;
import dorkbox.util.OS;
import java.io.IOException;

public class Header
implements Cloneable {
    private int id;
    private int flags;
    private int[] counts;
    private static final FastThreadLocal<MersenneTwisterFast> random = new FastThreadLocal<MersenneTwisterFast>(){

        @Override
        public MersenneTwisterFast initialValue() {
            return new MersenneTwisterFast();
        }
    };
    public static final int LENGTH = 12;

    public Header() {
        this.init();
    }

    private void init() {
        this.counts = new int[4];
        this.flags = 0;
        this.id = -1;
    }

    public Header(byte[] b) throws IOException {
        this(new DnsInput(b));
    }

    Header(DnsInput in) throws IOException {
        this(in.readU16());
        this.flags = in.readU16();
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = in.readU16();
        }
    }

    public Header(int id) {
        this.init();
        this.setID(id);
    }

    public byte[] toWire() {
        DnsOutput out = new DnsOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    void toWire(DnsOutput out) {
        out.writeU16(this.getID());
        out.writeU16(this.flags);
        for (int i = 0; i < this.counts.length; ++i) {
            out.writeU16(this.counts[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID() {
        if (this.id >= 0) {
            return this.id;
        }
        Header header = this;
        synchronized (header) {
            if (this.id < 0) {
                this.id = random.get().nextInt(65535);
            }
            return this.id;
        }
    }

    public void setID(int id) {
        if (id < 0 || id > 65535) {
            throw new IllegalArgumentException("DNS message ID " + id + " is out of range");
        }
        this.id = id;
    }

    public void setFlag(Flags flag) {
        Header.checkFlag(flag);
        this.flags = Header.setFlag(this.flags, flag, true);
    }

    private static void checkFlag(int flag) {
        if (!Flags.isFlag(flag)) {
            throw new IllegalArgumentException("invalid flag bit " + flag);
        }
    }

    private static void checkFlag(Flags flag) {
        if (!Header.validFlag(flag)) {
            throw new IllegalArgumentException("invalid flag bit " + (Object)((Object)flag));
        }
    }

    private static boolean validFlag(Flags flag) {
        return flag != null && flag.value() >= 0 && flag.value() <= 15 && Flags.isFlag(flag.value());
    }

    static int setFlag(int flags, Flags flag, boolean value) {
        Header.checkFlag(flag);
        if (value) {
            return flags |= 1 << 15 - flag.value();
        }
        return flags &= ~(1 << 15 - flag.value());
    }

    public void unsetFlag(Flags flag) {
        Header.checkFlag(flag);
        this.flags = Header.setFlag(this.flags, flag, false);
    }

    boolean[] getFlags() {
        boolean[] array = new boolean[16];
        for (int i = 0; i < array.length; ++i) {
            if (!Flags.isFlag(i)) continue;
            array[i] = this.getFlag(i);
        }
        return array;
    }

    public boolean getFlag(Flags flag) {
        return (this.flags & 1 << 15 - flag.value()) != 0;
    }

    private boolean getFlag(int flagValue) {
        return (this.flags & 1 << 15 - flagValue) != 0;
    }

    void setCount(int field, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("DNS section count " + value + " is out of range");
        }
        this.counts[field] = value;
    }

    void incCount(int field) {
        if (this.counts[field] == 65535) {
            throw new IllegalStateException("DNS section count cannot be incremented");
        }
        int n = field;
        this.counts[n] = this.counts[n] + 1;
    }

    void decCount(int field) {
        if (this.counts[field] == 0) {
            throw new IllegalStateException("DNS section count cannot be decremented");
        }
        int n = field;
        this.counts[n] = this.counts[n] - 1;
    }

    int getFlagsByte() {
        return this.flags;
    }

    public Object clone() {
        Header h = new Header();
        h.id = this.id;
        h.flags = this.flags;
        System.arraycopy(this.counts, 0, h.counts, 0, this.counts.length);
        return h;
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public int getRcode() {
        return this.flags & 0xF;
    }

    public void setRcode(int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("DNS DnsResponseCode " + value + " is out of range");
        }
        this.flags &= 0xFFFFFFF0;
        this.flags |= value;
    }

    String toStringWithRcode(int newrcode) {
        StringBuilder sb = new StringBuilder();
        sb.append(";; ->>HEADER<<- ");
        sb.append("opcode: " + DnsOpCode.string(this.getOpcode()));
        sb.append(", status: " + DnsResponseCode.string(newrcode));
        sb.append(", id: " + this.getID());
        sb.append(OS.LINE_SEPARATOR);
        sb.append(";; flags: ").append(this.printFlags());
        sb.append("; ");
        for (int i = 0; i < 4; ++i) {
            sb.append(DnsSection.string(i)).append(": ").append(this.getCount(i)).append(" ");
        }
        return sb.toString();
    }

    public int getOpcode() {
        return this.flags >> 11 & 0xF;
    }

    public void setOpcode(int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("DNS DnsOpCode " + value + "is out of range");
        }
        this.flags &= 0x87FF;
        this.flags |= value << 11;
    }

    public int getCount(int field) {
        return this.counts[field];
    }

    String printFlags() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (!Flags.isFlag(i) || !this.getFlag(i)) continue;
            Flags flag = Flags.toFlag(i);
            sb.append(flag.string());
            sb.append(" ");
        }
        return sb.toString();
    }
}

