/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class MINFORecord
extends DnsRecord {
    private static final long serialVersionUID = -3962147172340353796L;
    private Name responsibleAddress;
    private Name errorAddress;

    MINFORecord() {
    }

    @Override
    DnsRecord getObject() {
        return new MINFORecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.responsibleAddress = new Name(in);
        this.errorAddress = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.responsibleAddress.toWire(out, null, canonical);
        this.errorAddress.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.responsibleAddress);
        sb.append(" ");
        sb.append(this.errorAddress);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.responsibleAddress = st.getName(origin);
        this.errorAddress = st.getName(origin);
    }

    public MINFORecord(Name name, int dclass, long ttl, Name responsibleAddress, Name errorAddress) {
        super(name, 14, dclass, ttl);
        this.responsibleAddress = MINFORecord.checkName("responsibleAddress", responsibleAddress);
        this.errorAddress = MINFORecord.checkName("errorAddress", errorAddress);
    }

    public Name getResponsibleAddress() {
        return this.responsibleAddress;
    }

    public Name getErrorAddress() {
        return this.errorAddress;
    }
}

