/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class NAPTRRecord
extends DnsRecord {
    private static final long serialVersionUID = 5191232392044947002L;
    private int order;
    private int preference;
    private byte[] flags;
    private byte[] service;
    private byte[] regexp;
    private Name replacement;

    NAPTRRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new NAPTRRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.order = in.readU16();
        this.preference = in.readU16();
        this.flags = in.readCountedString();
        this.service = in.readCountedString();
        this.regexp = in.readCountedString();
        this.replacement = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.order);
        out.writeU16(this.preference);
        out.writeCountedString(this.flags);
        out.writeCountedString(this.service);
        out.writeCountedString(this.regexp);
        this.replacement.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.order);
        sb.append(" ");
        sb.append(this.preference);
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.flags, true));
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.service, true));
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.regexp, true));
        sb.append(" ");
        sb.append(this.replacement);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.order = st.getUInt16();
        this.preference = st.getUInt16();
        try {
            this.flags = NAPTRRecord.byteArrayFromString(st.getString());
            this.service = NAPTRRecord.byteArrayFromString(st.getString());
            this.regexp = NAPTRRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        this.replacement = st.getName(origin);
    }

    @Override
    public Name getAdditionalName() {
        return this.replacement;
    }

    public NAPTRRecord(Name name, int dclass, long ttl, int order, int preference, String flags, String service, String regexp, Name replacement) {
        super(name, 35, dclass, ttl);
        this.order = NAPTRRecord.checkU16("order", order);
        this.preference = NAPTRRecord.checkU16("preference", preference);
        try {
            this.flags = NAPTRRecord.byteArrayFromString(flags);
            this.service = NAPTRRecord.byteArrayFromString(service);
            this.regexp = NAPTRRecord.byteArrayFromString(regexp);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.replacement = NAPTRRecord.checkName("replacement", replacement);
    }

    public int getOrder() {
        return this.order;
    }

    public int getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return NAPTRRecord.byteArrayToString(this.flags, false);
    }

    public String getService() {
        return NAPTRRecord.byteArrayToString(this.service, false);
    }

    public String getRegexp() {
        return NAPTRRecord.byteArrayToString(this.regexp, false);
    }

    public Name getReplacement() {
        return this.replacement;
    }
}

