/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.TypeBitmap;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class NSECRecord
extends DnsRecord {
    private static final long serialVersionUID = -5165065768816265385L;
    private Name next;
    private TypeBitmap types;

    NSECRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new NSECRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.next = new Name(in);
        this.types = new TypeBitmap(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, false);
        this.types.toWire(out);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.next);
        if (!this.types.empty()) {
            sb.append(' ');
            sb.append(this.types.toString());
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.next = st.getName(origin);
        this.types = new TypeBitmap(st);
    }

    public NSECRecord(Name name, int dclass, long ttl, Name next, int[] types) {
        super(name, 47, dclass, ttl);
        this.next = NSECRecord.checkName("next", next);
        for (int i = 0; i < types.length; ++i) {
            DnsRecordType.check(types[i]);
        }
        this.types = new TypeBitmap(types);
    }

    public Name getNext() {
        return this.next;
    }

    public int[] getTypes() {
        return this.types.toArray();
    }

    public boolean hasType(int type) {
        return this.types.contains(type);
    }
}

