/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.EDNSOption;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OPTRecord
extends DnsRecord {
    private static final long serialVersionUID = -6254521894809367938L;
    private List options;

    OPTRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new OPTRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        if (in.remaining() > 0) {
            this.options = new ArrayList();
        }
        while (in.remaining() > 0) {
            EDNSOption option = EDNSOption.fromWire(in);
            this.options.add(option);
        }
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        if (this.options == null) {
            return;
        }
        for (EDNSOption option : this.options) {
            option.toWire(out);
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        if (this.options != null) {
            sb.append(this.options);
            sb.append(" ");
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for OPT");
    }

    @Override
    public boolean equals(Object arg) {
        return super.equals(arg) && this.ttl == ((OPTRecord)arg).ttl;
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags) {
        this(payloadSize, xrcode, version, flags, null);
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags, List options) {
        super(Name.root, 41, payloadSize, 0L);
        OPTRecord.checkU16("payloadSize", payloadSize);
        OPTRecord.checkU8("xrcode", xrcode);
        OPTRecord.checkU8("version", version);
        OPTRecord.checkU16("flags", flags);
        this.ttl = ((long)xrcode << 24) + ((long)version << 16) + (long)flags;
        if (options != null) {
            this.options = new ArrayList(options);
        }
    }

    public OPTRecord(int payloadSize, int xrcode, int version) {
        this(payloadSize, xrcode, version, 0, null);
    }

    public List getOptions() {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.options);
    }

    public List getOptions(int code) {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EDNSOption> list = Collections.EMPTY_LIST;
        for (EDNSOption opt : this.options) {
            if (opt.getCode() != code) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<EDNSOption>();
            }
            list.add(opt);
        }
        return list;
    }
}

