/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsClass;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.RRSIGRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RRset
implements Serializable {
    private static final long serialVersionUID = -3270249290171239695L;
    private List resourceRecords;
    private short nsigs;
    private short position;

    public RRset(DnsRecord record) {
        this();
        this.safeAddRR(record);
    }

    public RRset() {
        this.resourceRecords = new ArrayList(1);
        this.nsigs = 0;
        this.position = 0;
    }

    private void safeAddRR(DnsRecord r) {
        if (!(r instanceof RRSIGRecord)) {
            if (this.nsigs == 0) {
                this.resourceRecords.add(r);
            } else {
                this.resourceRecords.add(this.resourceRecords.size() - this.nsigs, r);
            }
        } else {
            this.resourceRecords.add(r);
            this.nsigs = (short)(this.nsigs + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RRset(RRset rrset) {
        RRset rRset = rrset;
        synchronized (rRset) {
            this.resourceRecords = (List)((ArrayList)rrset.resourceRecords).clone();
            this.nsigs = rrset.nsigs;
            this.position = rrset.position;
        }
    }

    public synchronized void addRR(DnsRecord r) {
        if (this.resourceRecords.size() == 0) {
            this.safeAddRR(r);
            return;
        }
        DnsRecord first = this.first();
        if (!r.sameRRset(first)) {
            throw new IllegalArgumentException("record does not match rrset");
        }
        if (r.getTTL() != first.getTTL()) {
            if (r.getTTL() > first.getTTL()) {
                r = r.cloneRecord();
                r.setTTL(first.getTTL());
            } else {
                for (int i = 0; i < this.resourceRecords.size(); ++i) {
                    DnsRecord tmp = (DnsRecord)this.resourceRecords.get(i);
                    tmp = tmp.cloneRecord();
                    tmp.setTTL(r.getTTL());
                    this.resourceRecords.set(i, tmp);
                }
            }
        }
        if (!this.resourceRecords.contains(r)) {
            this.safeAddRR(r);
        }
    }

    public synchronized DnsRecord first() {
        if (this.resourceRecords.size() == 0) {
            throw new IllegalStateException("rrset is empty");
        }
        return (DnsRecord)this.resourceRecords.get(0);
    }

    public synchronized void deleteRR(DnsRecord r) {
        if (this.resourceRecords.remove(r) && r instanceof RRSIGRecord) {
            this.nsigs = (short)(this.nsigs - 1);
        }
    }

    public synchronized void clear() {
        this.resourceRecords.clear();
        this.position = 0;
        this.nsigs = 0;
    }

    public synchronized Iterator rrs(boolean cycle) {
        return this.iterator(true, cycle);
    }

    private synchronized Iterator iterator(boolean data, boolean cycle) {
        int start;
        int total = this.resourceRecords.size();
        int size = data ? total - this.nsigs : this.nsigs;
        if (size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (data) {
            if (!cycle) {
                start = 0;
            } else {
                if (this.position >= size) {
                    this.position = 0;
                }
                short s = this.position;
                this.position = (short)(s + 1);
                start = s;
            }
        } else {
            start = total - this.nsigs;
        }
        ArrayList list = new ArrayList(size);
        if (data) {
            list.addAll(this.resourceRecords.subList(start, size));
            if (start != 0) {
                list.addAll(this.resourceRecords.subList(0, start));
            }
        } else {
            list.addAll(this.resourceRecords.subList(start, total));
        }
        return list.iterator();
    }

    public synchronized Iterator rrs() {
        return this.iterator(true, true);
    }

    public synchronized Iterator sigs() {
        return this.iterator(false, false);
    }

    public synchronized int size() {
        return this.resourceRecords.size() - this.nsigs;
    }

    public String toString() {
        if (this.resourceRecords.size() == 0) {
            return "{empty}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.getName() + " ");
        sb.append(this.getTTL() + " ");
        sb.append(DnsClass.string(this.getDClass()) + " ");
        sb.append(DnsRecordType.string(this.getType()) + " ");
        sb.append(this.iteratorToString(this.iterator(true, false)));
        if (this.nsigs > 0) {
            sb.append(" sigs: ");
            sb.append(this.iteratorToString(this.iterator(false, false)));
        }
        sb.append(" }");
        return sb.toString();
    }

    public Name getName() {
        return this.first().getName();
    }

    public int getType() {
        return this.first().getRRsetType();
    }

    public int getDClass() {
        return this.first().getDClass();
    }

    public synchronized long getTTL() {
        return this.first().getTTL();
    }

    private String iteratorToString(Iterator it) {
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            DnsRecord rr = (DnsRecord)it.next();
            sb.append("[");
            rr.rdataToString(sb);
            sb.append("]");
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

