/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DNSSEC;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.TTL;
import dorkbox.network.dns.utils.FormattedTime;
import dorkbox.network.dns.utils.Options;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.util.Base64Fast;
import dorkbox.util.OS;
import java.io.IOException;
import java.util.Date;

abstract class SIGBase
extends DnsRecord {
    private static final long serialVersionUID = -3738444391533812369L;
    protected int covered;
    protected int alg;
    protected int labels;
    protected long origttl;
    protected Date expire;
    protected Date timeSigned;
    protected int footprint;
    protected Name signer;
    protected byte[] signature;

    protected SIGBase() {
    }

    public SIGBase(Name name, int type, int dclass, long ttl, int covered, int alg, long origttl, Date expire, Date timeSigned, int footprint, Name signer, byte[] signature) {
        super(name, type, dclass, ttl);
        DnsRecordType.check(covered);
        TTL.check(origttl);
        this.covered = covered;
        this.alg = SIGBase.checkU8("alg", alg);
        this.labels = name.labels() - 1;
        if (name.isWild()) {
            --this.labels;
        }
        this.origttl = origttl;
        this.expire = expire;
        this.timeSigned = timeSigned;
        this.footprint = SIGBase.checkU16("footprint", footprint);
        this.signer = SIGBase.checkName("signer", signer);
        this.signature = signature;
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.covered = in.readU16();
        this.alg = in.readU8();
        this.labels = in.readU8();
        this.origttl = in.readU32();
        this.expire = new Date(1000L * in.readU32());
        this.timeSigned = new Date(1000L * in.readU32());
        this.footprint = in.readU16();
        this.signer = new Name(in);
        this.signature = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.covered);
        out.writeU8(this.alg);
        out.writeU8(this.labels);
        out.writeU32(this.origttl);
        out.writeU32(this.expire.getTime() / 1000L);
        out.writeU32(this.timeSigned.getTime() / 1000L);
        out.writeU16(this.footprint);
        this.signer.toWire(out, null, canonical);
        out.writeByteArray(this.signature);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(DnsRecordType.string(this.covered));
        sb.append(" ");
        sb.append(this.alg);
        sb.append(" ");
        sb.append(this.labels);
        sb.append(" ");
        sb.append(this.origttl);
        sb.append(" ");
        if (Options.check("multiline")) {
            sb.append("(\n\t");
        }
        sb.append(FormattedTime.format(this.expire));
        sb.append(" ");
        sb.append(FormattedTime.format(this.timeSigned));
        sb.append(" ");
        sb.append(this.footprint);
        sb.append(" ");
        sb.append(this.signer);
        if (Options.check("multiline")) {
            sb.append(OS.LINE_SEPARATOR);
            sb.append(Base64Fast.formatString(Base64Fast.encode2(this.signature), 64, "\t", true));
        } else {
            sb.append(" ");
            sb.append(Base64Fast.encode2(this.signature));
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String typeString = st.getString();
        this.covered = DnsRecordType.value(typeString);
        if (this.covered < 0) {
            throw st.exception("Invalid type: " + typeString);
        }
        String algString = st.getString();
        this.alg = DNSSEC.Algorithm.value(algString);
        if (this.alg < 0) {
            throw st.exception("Invalid algorithm: " + algString);
        }
        this.labels = st.getUInt8();
        this.origttl = st.getTTL();
        this.expire = FormattedTime.parse(st.getString());
        this.timeSigned = FormattedTime.parse(st.getString());
        this.footprint = st.getUInt16();
        this.signer = st.getName(origin);
        this.signature = st.getBase64();
    }

    public int getTypeCovered() {
        return this.covered;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public int getLabels() {
        return this.labels;
    }

    public long getOrigTTL() {
        return this.origttl;
    }

    public Date getExpire() {
        return this.expire;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFootprint() {
        return this.footprint;
    }

    public Name getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    void setSignature(byte[] signature) {
        this.signature = signature;
    }
}

