/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsResponseCode;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.FormattedTime;
import dorkbox.network.dns.utils.Options;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.util.Base64Fast;
import dorkbox.util.OS;
import java.io.IOException;
import java.util.Date;

public class TKEYRecord
extends DnsRecord {
    private static final long serialVersionUID = 8828458121926391756L;
    private Name alg;
    private Date timeInception;
    private Date timeExpire;
    private int mode;
    private int error;
    private byte[] key;
    private byte[] other;
    public static final int SERVERASSIGNED = 1;
    public static final int DIFFIEHELLMAN = 2;
    public static final int GSSAPI = 3;
    public static final int RESOLVERASSIGNED = 4;
    public static final int DELETE = 5;

    TKEYRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new TKEYRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.alg = new Name(in);
        this.timeInception = new Date(1000L * in.readU32());
        this.timeExpire = new Date(1000L * in.readU32());
        this.mode = in.readU16();
        this.error = in.readU16();
        int keylen = in.readU16();
        this.key = (byte[])(keylen > 0 ? in.readByteArray(keylen) : null);
        int otherlen = in.readU16();
        this.other = (byte[])(otherlen > 0 ? in.readByteArray(otherlen) : null);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.alg.toWire(out, null, canonical);
        out.writeU32(this.timeInception.getTime() / 1000L);
        out.writeU32(this.timeExpire.getTime() / 1000L);
        out.writeU16(this.mode);
        out.writeU16(this.error);
        if (this.key != null) {
            out.writeU16(this.key.length);
            out.writeByteArray(this.key);
        } else {
            out.writeU16(0);
        }
        if (this.other != null) {
            out.writeU16(this.other.length);
            out.writeByteArray(this.other);
        } else {
            out.writeU16(0);
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.alg);
        sb.append(" ");
        if (Options.check("multiline")) {
            sb.append("(").append(OS.LINE_SEPARATOR).append("\t");
        }
        sb.append(FormattedTime.format(this.timeInception));
        sb.append(" ");
        sb.append(FormattedTime.format(this.timeExpire));
        sb.append(" ");
        sb.append(this.modeString());
        sb.append(" ");
        sb.append(DnsResponseCode.TSIGstring(this.error));
        if (Options.check("multiline")) {
            sb.append(OS.LINE_SEPARATOR);
            if (this.key != null) {
                sb.append(Base64Fast.formatString(Base64Fast.encode2(this.key), 64, "\t", true));
                sb.append(OS.LINE_SEPARATOR);
            }
            if (this.other != null) {
                sb.append(Base64Fast.formatString(Base64Fast.encode2(this.other), 64, "\t", true));
            }
            sb.append(" )");
        } else {
            sb.append(" ");
            if (this.key != null) {
                sb.append("\t");
                sb.append(Base64Fast.encode2(this.key));
                sb.append(" ");
            }
            if (this.other != null) {
                sb.append("\t");
                sb.append(Base64Fast.encode2(this.other));
            }
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for TKEY");
    }

    protected String modeString() {
        switch (this.mode) {
            case 1: {
                return "SERVERASSIGNED";
            }
            case 2: {
                return "DIFFIEHELLMAN";
            }
            case 3: {
                return "GSSAPI";
            }
            case 4: {
                return "RESOLVERASSIGNED";
            }
            case 5: {
                return "DELETE";
            }
        }
        return Integer.toString(this.mode);
    }

    public TKEYRecord(Name name, int dclass, long ttl, Name alg, Date timeInception, Date timeExpire, int mode, int error, byte[] key, byte[] other) {
        super(name, 249, dclass, ttl);
        this.alg = TKEYRecord.checkName("alg", alg);
        this.timeInception = timeInception;
        this.timeExpire = timeExpire;
        this.mode = TKEYRecord.checkU16("mode", mode);
        this.error = TKEYRecord.checkU16("error", error);
        this.key = key;
        this.other = other;
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeInception() {
        return this.timeInception;
    }

    public Date getTimeExpire() {
        return this.timeExpire;
    }

    public int getMode() {
        return this.mode;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getOther() {
        return this.other;
    }
}

