/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.network.dns.utils.base16;
import java.io.IOException;

public class TLSARecord
extends DnsRecord {
    private static final long serialVersionUID = 356494267028580169L;
    private int certificateUsage;
    private int selector;
    private int matchingType;
    private byte[] certificateAssociationData;

    TLSARecord() {
    }

    @Override
    DnsRecord getObject() {
        return new TLSARecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.certificateUsage = in.readU8();
        this.selector = in.readU8();
        this.matchingType = in.readU8();
        this.certificateAssociationData = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU8(this.certificateUsage);
        out.writeU8(this.selector);
        out.writeU8(this.matchingType);
        out.writeByteArray(this.certificateAssociationData);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.certificateUsage);
        sb.append(" ");
        sb.append(this.selector);
        sb.append(" ");
        sb.append(this.matchingType);
        sb.append(" ");
        sb.append(base16.toString(this.certificateAssociationData));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.certificateUsage = st.getUInt8();
        this.selector = st.getUInt8();
        this.matchingType = st.getUInt8();
        this.certificateAssociationData = st.getHex();
    }

    public TLSARecord(Name name, int dclass, long ttl, int certificateUsage, int selector, int matchingType, byte[] certificateAssociationData) {
        super(name, 52, dclass, ttl);
        this.certificateUsage = TLSARecord.checkU8("certificateUsage", certificateUsage);
        this.selector = TLSARecord.checkU8("selector", selector);
        this.matchingType = TLSARecord.checkU8("matchingType", matchingType);
        this.certificateAssociationData = TLSARecord.checkByteArrayLength("certificateAssociationData", certificateAssociationData, 65535);
    }

    public int getCertificateUsage() {
        return this.certificateUsage;
    }

    public int getSelector() {
        return this.selector;
    }

    public int getMatchingType() {
        return this.matchingType;
    }

    public final byte[] getCertificateAssociationData() {
        return this.certificateAssociationData;
    }

    public static class CertificateUsage {
        public static final int CA_CONSTRAINT = 0;
        public static final int SERVICE_CERTIFICATE_CONSTRAINT = 1;
        public static final int TRUST_ANCHOR_ASSERTION = 2;
        public static final int DOMAIN_ISSUED_CERTIFICATE = 3;

        private CertificateUsage() {
        }
    }

    public static class MatchingType {
        public static final int EXACT = 0;
        public static final int SHA256 = 1;
        public static final int SHA512 = 2;

        private MatchingType() {
        }
    }

    public static class Selector {
        public static final int FULL_CERTIFICATE = 0;
        public static final int SUBJECT_PUBLIC_KEY_INFO = 1;

        private Selector() {
        }
    }
}

