/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsClass;
import dorkbox.network.dns.exceptions.RelativeNameException;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.RRset;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.util.Iterator;

public class Update
extends DnsMessage {
    private Name origin;
    private int dclass;

    public Update(Name zone) {
        this(zone, 1);
    }

    public Update(Name zone, int dclass) {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DnsClass.check(dclass);
        this.getHeader().setOpcode(5);
        DnsRecord soa = DnsRecord.newRecord(zone, 6, 1);
        this.addRecord(soa, 0);
        this.origin = zone;
        this.dclass = dclass;
    }

    public void present(Name name) {
        this.newPrereq(DnsRecord.newRecord(name, 255, 255, 0L));
    }

    private void newPrereq(DnsRecord rec) {
        this.addRecord(rec, 1);
    }

    public void present(Name name, int type) {
        this.newPrereq(DnsRecord.newRecord(name, type, 255, 0L));
    }

    public void present(Name name, int type, String record) throws IOException {
        this.newPrereq(DnsRecord.fromString(name, type, this.dclass, 0L, record, this.origin));
    }

    public void present(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newPrereq(DnsRecord.fromString(name, type, this.dclass, 0L, tokenizer, this.origin));
    }

    public void present(DnsRecord record) {
        this.newPrereq(record);
    }

    public void absent(Name name) {
        this.newPrereq(DnsRecord.newRecord(name, 255, 254, 0L));
    }

    public void absent(Name name, int type) {
        this.newPrereq(DnsRecord.newRecord(name, type, 254, 0L));
    }

    public void add(DnsRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.add(records[i]);
        }
    }

    public void add(DnsRecord record) {
        this.newUpdate(record);
    }

    private void newUpdate(DnsRecord rec) {
        this.addRecord(rec, 2);
    }

    public void add(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((DnsRecord)it.next());
        }
    }

    public void delete(Name name) {
        this.newUpdate(DnsRecord.newRecord(name, 255, 255, 0L));
    }

    public void delete(Name name, int type, String record) throws IOException {
        this.newUpdate(DnsRecord.fromString(name, type, 254, 0L, record, this.origin));
    }

    public void delete(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newUpdate(DnsRecord.fromString(name, type, 254, 0L, tokenizer, this.origin));
    }

    public void delete(DnsRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.delete(records[i]);
        }
    }

    public void delete(DnsRecord record) {
        this.newUpdate(record.withDClass(254, 0L));
    }

    public void delete(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.delete((DnsRecord)it.next());
        }
    }

    public void replace(Name name, int type, long ttl, String record) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, record);
    }

    public void add(Name name, int type, long ttl, String record) throws IOException {
        this.newUpdate(DnsRecord.fromString(name, type, this.dclass, ttl, record, this.origin));
    }

    public void delete(Name name, int type) {
        this.newUpdate(DnsRecord.newRecord(name, type, 255, 0L));
    }

    public void replace(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, tokenizer);
    }

    public void add(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.newUpdate(DnsRecord.fromString(name, type, this.dclass, ttl, tokenizer, this.origin));
    }

    public void replace(DnsRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.replace(records[i]);
        }
    }

    public void replace(DnsRecord record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }

    public void replace(RRset rrset) {
        this.delete(rrset.getName(), rrset.getType());
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((DnsRecord)it.next());
        }
    }
}

