/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.clientHandlers.DnsResponse;
import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.network.dns.resolver.DnsQueryContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;

final class DnsNameResolverResponseHandler
extends ChannelInboundHandlerAdapter {
    private DnsNameResolver dnsNameResolver;
    private final Promise<Channel> channelActivePromise;

    DnsNameResolverResponseHandler(DnsNameResolver dnsNameResolver, Promise<Channel> channelActivePromise) {
        this.dnsNameResolver = dnsNameResolver;
        this.channelActivePromise = channelActivePromise;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channelActivePromise.setSuccess((Object)ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        DnsQueryContext qCtx;
        DnsResponse response = (DnsResponse)msg;
        int queryId = response.getHeader().getID();
        if (DnsNameResolver.logger.isDebugEnabled()) {
            DnsNameResolver.logger.debug("{} RECEIVED: [{}: {}], {}", new Object[]{this.dnsNameResolver.ch, queryId, response.sender(), response});
        }
        if ((qCtx = this.dnsNameResolver.queryContextManager.get(response.sender(), queryId)) == null) {
            DnsNameResolver.logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)this.dnsNameResolver.ch, (Object)queryId);
            return;
        }
        qCtx.finish(response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        DnsNameResolver.logger.warn("{} Unexpected exception: ", (Object)this.dnsNameResolver.ch, (Object)cause);
    }
}

