/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class InetSocketAddressGroupResolver
extends AbstractAddressResolver<InetSocketAddress> {
    final NameResolver<List<InetAddress>> nameResolver;

    public InetSocketAddressGroupResolver(EventExecutor executor, NameResolver<List<InetAddress>> nameResolver) {
        super(executor, InetSocketAddress.class);
        this.nameResolver = nameResolver;
    }

    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    protected void doResolve(final InetSocketAddress unresolvedAddress, final Promise<InetSocketAddress> promise) throws Exception {
        this.nameResolver.resolve(unresolvedAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
                    List now = (List)future.getNow();
                    for (InetAddress inetAddress : now) {
                        arrayList.add(new InetSocketAddress(inetAddress, unresolvedAddress.getPort()));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    protected void doResolveAll(final InetSocketAddress unresolvedAddress, final Promise<List<InetSocketAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(unresolvedAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<List<List<InetAddress>>>(){

            public void operationComplete(Future<List<List<InetAddress>>> future) throws Exception {
                if (future.isSuccess()) {
                    List inetAddresseses = (List)future.getNow();
                    ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(inetAddresseses.size());
                    for (List inetAddresses : inetAddresseses) {
                        for (InetAddress inetAddress : inetAddresses) {
                            socketAddresses.add(new InetSocketAddress(inetAddress, unresolvedAddress.getPort()));
                        }
                    }
                    promise.setSuccess(socketAddresses);
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    public void close() {
        this.nameResolver.close();
    }
}

