/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.server;

import dorkbox.network.dns.constants.Flags;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.server.DefaultResponse;
import java.util.Set;

public class NoErrorResponse
extends DefaultResponse {
    final Set<DnsRecord> records;
    final boolean authoritativeAnswer;

    public NoErrorResponse(Set<DnsRecord> records) {
        this(records, true);
    }

    public NoErrorResponse(Set<DnsRecord> records, boolean authoritativeAnswer) {
        super(0);
        this.records = records;
        this.authoritativeAnswer = authoritativeAnswer;
    }

    @Override
    public void postProcess(DnsMessage message) {
        message.getHeader().setRcode(this.responseCode());
        message.getHeader().setFlag(Flags.QR);
        if (this.authoritativeAnswer) {
            message.getHeader().setFlag(Flags.AA);
        } else {
            message.getHeader().unsetFlag(Flags.AA);
        }
        for (DnsRecord record : this.records) {
            message.addRecord(record, 1);
        }
    }
}

