/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.serverHandlers;

import dorkbox.network.DnsClient;
import dorkbox.network.dns.DnsEnvelope;
import dorkbox.network.dns.DnsServerResponse;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.Flags;
import dorkbox.network.dns.records.ARecord;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.Header;
import dorkbox.network.dns.records.Update;
import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.util.collections.LockFreeHashMap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class DnsDecisionHandler
extends ChannelInboundHandlerAdapter {
    private final Logger logger;
    private final LockFreeHashMap<Name, ArrayList<ARecord>> aRecordMap;
    private final DnsClient dnsClient;

    public DnsDecisionHandler(Logger logger) {
        this.logger = logger;
        this.dnsClient = new DnsClient();
        this.dnsClient.start();
        this.aRecordMap = new LockFreeHashMap();
    }

    public void addARecord(Name domainName, ArrayList<ARecord> aRecords) {
        this.aRecordMap.put(domainName, aRecords);
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        this.onChannelRead(context, (DnsEnvelope)message);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        this.logger.error("DecisionHandler#exceptionCaught", cause);
        super.exceptionCaught(context, cause);
    }

    private void onChannelRead(ChannelHandlerContext context, DnsEnvelope dnsMessage) {
        int opcode = dnsMessage.getHeader().getOpcode();
        switch (opcode) {
            case 0: {
                this.onQuery(context, dnsMessage, dnsMessage.recipient());
                return;
            }
            case 1: {
                this.onIQuery(context, dnsMessage, dnsMessage.recipient());
                return;
            }
            case 4: {
                this.onNotify(context, dnsMessage, dnsMessage.recipient());
                return;
            }
            case 2: {
                this.onStatus(context, dnsMessage, dnsMessage.recipient());
                return;
            }
            case 5: {
                this.onUpdate(context, (Update)((Object)dnsMessage), dnsMessage.recipient());
                return;
            }
        }
        this.logger.error("Unknown DNS opcode {} from {}", (Object)opcode, (Object)context.channel().remoteAddress());
    }

    private void onIQuery(ChannelHandlerContext context, DnsMessage dnsQuestion, InetSocketAddress recipient) {
        System.err.println("DECISION HANDLER READ");
        System.err.println(dnsQuestion);
    }

    private void onNotify(ChannelHandlerContext context, DnsMessage dnsQuestion, InetSocketAddress recipient) {
        System.err.println("DECISION HANDLER READ");
        System.err.println(dnsQuestion);
    }

    private void onQuery(final ChannelHandlerContext context, final DnsMessage dnsQuestion, final InetSocketAddress recipient) {
        Header header = dnsQuestion.getHeader();
        int count = header.getCount(0);
        if (count == 1) {
            DnsRecord[] sectionArray = dnsQuestion.getSectionArray(0);
            final DnsRecord dnsRecord = sectionArray[0];
            final Name name = dnsRecord.getName();
            final long ttl = dnsRecord.getTTL();
            int type = dnsRecord.getType();
            if (1 == type) {
                String domainName;
                DnsNameResolver resolver = this.dnsClient.getResolver();
                InetAddress inetAddress = resolver.resolveHostsFileEntry(domainName = name.toString(true));
                if (inetAddress != null) {
                    DnsServerResponse dnsResponse = new DnsServerResponse(dnsQuestion, (InetSocketAddress)context.channel().localAddress(), recipient);
                    Header responseHeader = dnsResponse.getHeader();
                    responseHeader.setFlag(Flags.QR);
                    responseHeader.setRcode(0);
                    dnsResponse.addRecord(dnsRecord, 0);
                    ARecord aRecord = new ARecord(name, dnsRecord.getDClass(), ttl, inetAddress);
                    dnsResponse.addRecord(aRecord, 1);
                    context.channel().write((Object)dnsResponse);
                    return;
                }
                ArrayList<ARecord> records = this.aRecordMap.get(name);
                if (records != null) {
                    DnsServerResponse dnsResponse = new DnsServerResponse(dnsQuestion, (InetSocketAddress)context.channel().localAddress(), recipient);
                    Header responseHeader = dnsResponse.getHeader();
                    responseHeader.setFlag(Flags.QR);
                    responseHeader.setRcode(0);
                    dnsResponse.addRecord(dnsRecord, 0);
                    for (ARecord record : records) {
                        dnsResponse.addRecord(record, 1);
                        this.logger.debug("Writing A record response: {}", (Object)record.getAddress());
                    }
                    context.channel().write((Object)dnsResponse);
                    return;
                }
                this.logger.debug("Sending DNS query to the forwarder...");
                resolver.resolveAll(domainName).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

                    public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                        List resolvedAddresses = (List)future.getNow();
                        DnsServerResponse dnsResponse = new DnsServerResponse(dnsQuestion, (InetSocketAddress)context.channel().localAddress(), recipient);
                        Header responseHeader = dnsResponse.getHeader();
                        responseHeader.setFlag(Flags.QR);
                        dnsResponse.addRecord(dnsRecord, 0);
                        if (resolvedAddresses == null || resolvedAddresses.isEmpty()) {
                            responseHeader.setRcode(3);
                        } else {
                            responseHeader.setRcode(0);
                            ArrayList<ARecord> records = new ArrayList<ARecord>();
                            for (int i = 0; i < resolvedAddresses.size(); ++i) {
                                InetAddress resolvedAddress = (InetAddress)resolvedAddresses.get(i);
                                ARecord record = new ARecord(name, dnsRecord.getDClass(), ttl, resolvedAddress);
                                records.add(record);
                                dnsResponse.addRecord(record, 1);
                            }
                            DnsDecisionHandler.this.aRecordMap.put(name, records);
                        }
                        context.channel().write((Object)dnsResponse);
                    }
                });
            }
            return;
        }
        DnsRecord[] sectionArray = dnsQuestion.getSectionArray(0);
        DnsRecord dnsRecord = sectionArray[0];
        System.err.println(dnsRecord);
    }

    private void onStatus(ChannelHandlerContext context, DnsMessage dnsQuestion, InetSocketAddress recipient) {
        System.err.println("DECISION HANDLER READ");
        System.err.println(dnsQuestion);
    }

    private void onUpdate(ChannelHandlerContext context, Update dnsUpdate, InetSocketAddress recipient) {
        System.err.println("DECISION HANDLER READ");
        System.err.println(dnsUpdate);
    }

    public void stop() {
        this.dnsClient.stop();
    }
}

