/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.serverHandlers;

import dorkbox.network.dns.DnsEnvelope;
import dorkbox.network.dns.exceptions.WireParseException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;

class DnsMessageDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final Logger logger;

    DnsMessageDecoder(Logger logger) {
        this.logger = logger;
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        this.logger.error("DnsMessageDecoder#exceptionCaught", cause);
        super.exceptionCaught(context, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext context, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        if (buf.readableBytes() < 12) {
            throw new WireParseException("invalid DNS header - too short");
        }
        boolean success = false;
        try {
            InetSocketAddress localAddress = (InetSocketAddress)packet.recipient();
            InetSocketAddress remoteAddress = (InetSocketAddress)packet.sender();
            DnsEnvelope dnsEnvelope = new DnsEnvelope(buf, localAddress, remoteAddress);
            out.add(dnsEnvelope);
            success = true;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
    }
}

