/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.serverHandlers;

import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.DnsServerResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class DnsMessageEncoder
extends MessageToByteEncoder<DnsServerResponse> {
    private final Logger logger;

    public DnsMessageEncoder(Logger logger) {
        this.logger = logger;
    }

    protected void encode(ChannelHandlerContext context, DnsServerResponse message, ByteBuf out) throws Exception {
        try {
            DnsOutput dnsOutput = new DnsOutput(out);
            out.retain();
            message.toWire(dnsOutput);
            DatagramPacket packet = new DatagramPacket(out, message.recipient(), message.sender());
            context.channel().writeAndFlush((Object)packet);
        }
        catch (Exception e) {
            context.fireExceptionCaught((Throwable)new IOException("Unable to write dns message: " + message, e));
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        this.logger.error("DnsMessageEncoder#exceptionCaught", cause);
        super.exceptionCaught(context, cause);
    }
}

