/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.serverHandlers;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.ARecord;
import dorkbox.network.dns.serverHandlers.DnsDecisionHandler;
import dorkbox.network.dns.serverHandlers.DnsMessageDecoder;
import dorkbox.network.dns.serverHandlers.DnsMessageEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import org.slf4j.Logger;

public class DnsServerHandler
extends ChannelInboundHandlerAdapter {
    protected final DnsMessageDecoder decoder;
    private final Logger logger;
    private DnsDecisionHandler decisionHandler;
    private DnsMessageEncoder encoder;

    public DnsServerHandler(Logger logger) {
        this.logger = logger;
        this.decoder = new DnsMessageDecoder(logger);
        this.decisionHandler = new DnsDecisionHandler(logger);
        this.encoder = new DnsMessageEncoder(logger);
    }

    public void stop() {
        this.decisionHandler.stop();
    }

    public void addARecord(Name domainName, ArrayList<ARecord> aRecords) {
        this.decisionHandler.addARecord(domainName, aRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRegistered(ChannelHandlerContext context) {
        boolean success = false;
        try {
            this.initChannel(context.channel());
            context.fireChannelRegistered();
            success = true;
        }
        catch (Throwable t) {
            this.logger.error("Failed to initialize a channel. Closing: {}", (Object)context.channel(), (Object)t);
        }
        finally {
            if (!success) {
                context.close();
            }
        }
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)this.decoder);
        pipeline.addLast("dnsDecision", (ChannelHandler)this.decisionHandler);
        pipeline.addLast("encoder", (ChannelHandler)this.encoder);
    }
}

