/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.zone;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.SOARecord;
import dorkbox.network.dns.server.CNAMEResponse;
import dorkbox.network.dns.server.DNAMEResponse;
import dorkbox.network.dns.server.NoErrorResponse;
import dorkbox.network.dns.server.NotFoundResponse;
import dorkbox.network.dns.server.ReferralResponse;
import dorkbox.network.dns.server.Response;
import dorkbox.network.dns.zone.AbstractZone;
import dorkbox.network.dns.zone.ZoneType;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class MasterZone
extends AbstractZone {
    final ConcurrentMap<Name, ConcurrentMap<Integer, NavigableSet<DnsRecord>>> records = new ConcurrentSkipListMap<Name, ConcurrentMap<Integer, NavigableSet<DnsRecord>>>();
    final Response nxDomain;
    final Response nxRRSet;

    public MasterZone(Name name, SOARecord soaRecord) {
        super(ZoneType.master, name);
        this.nxDomain = new NotFoundResponse(3, soaRecord);
        this.nxRRSet = new NotFoundResponse(8, soaRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(DnsRecord rr) {
        while (true) {
            ConcurrentMap current;
            if ((current = (ConcurrentMap)this.records.get(rr.getName())) == null) {
                ConcurrentSkipListMap newone = new ConcurrentSkipListMap();
                ConcurrentSkipListSet<DnsRecord> newset = new ConcurrentSkipListSet<DnsRecord>();
                newset.add(rr);
                newone.put(rr.getType(), newset);
                ConcurrentMap prevTypes = this.records.putIfAbsent(rr.getName(), newone);
                if (prevTypes == null) break;
                ConcurrentMap concurrentMap = prevTypes;
                synchronized (concurrentMap) {
                    Set prevRecs = prevTypes.putIfAbsent(rr.getType(), newset);
                    if (prevRecs == null) {
                        break;
                    }
                    prevRecs.add(rr);
                    break;
                }
            }
            ConcurrentMap concurrentMap = current;
            synchronized (concurrentMap) {
                Set rrs = (Set)current.get(rr.getType());
                if (rrs == null) {
                    ConcurrentSkipListSet<DnsRecord> newset = new ConcurrentSkipListSet<DnsRecord>();
                    newset.add(rr);
                    current.put(rr.getType(), newset);
                    break;
                }
                if (!rrs.isEmpty()) {
                    rrs.add(rr);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response find(Name queryName, int recordType) {
        if (!queryName.equals(this.name)) {
            return this.nxDomain;
        }
        ConcurrentMap exactMatch = (ConcurrentMap)this.records.get(queryName);
        if (exactMatch != null) {
            Set newset;
            NavigableSet rrs = (NavigableSet)exactMatch.get(recordType);
            if (rrs != null) {
                NavigableSet navigableSet = rrs;
                synchronized (navigableSet) {
                    if (rrs.isEmpty()) {
                        return new NoErrorResponse(rrs);
                    }
                }
            }
            if (255 == recordType) {
                newset = new HashSet();
                for (Integer type : exactMatch.keySet()) {
                    Set s = (Set)exactMatch.get(type);
                    if (s == null) continue;
                    Set set = s;
                    synchronized (set) {
                        newset.addAll(s);
                    }
                }
                if (newset.isEmpty()) {
                    return null;
                }
            }
            if (5 == recordType && (rrs = (NavigableSet)exactMatch.get(5)) != null) {
                newset = rrs;
                synchronized (newset) {
                    if (!rrs.isEmpty()) {
                        return new CNAMEResponse((DnsRecord)rrs.first(), recordType);
                    }
                }
            }
            return this.nxRRSet;
        }
        Name qn = queryName.parent(1);
        while (!this.name().equals(qn)) {
            ConcurrentMap match = (ConcurrentMap)this.records.get(qn);
            if (match != null) {
                ConcurrentMap concurrentMap = match;
                synchronized (concurrentMap) {
                    if (!match.isEmpty()) {
                        NavigableSet set = (NavigableSet)match.get(2);
                        if (set != null && !set.isEmpty()) {
                            return new ReferralResponse(set);
                        }
                        set = (NavigableSet)match.get(39);
                        if (set != null && !set.isEmpty()) {
                            return new DNAMEResponse((DnsRecord)set.first(), queryName, recordType);
                        }
                    }
                }
            }
            qn = qn.parent(1);
        }
        qn = queryName;
        while (!this.name().equals(qn)) {
            Name wild = qn.wild(1);
            ConcurrentMap match = (ConcurrentMap)this.records.get(wild);
            if (match != null) {
                ConcurrentMap concurrentMap = match;
                synchronized (concurrentMap) {
                    Set matchSet;
                    if (!match.isEmpty() && !(matchSet = (Set)match.get(recordType)).isEmpty()) {
                        HashSet<DnsRecord> set = new HashSet<DnsRecord>(matchSet.size());
                        for (DnsRecord rr : matchSet) {
                            set.add(DnsRecord.newRecord(queryName, rr.getType(), rr.getDClass(), rr.getTTL()));
                        }
                        return new NoErrorResponse(set);
                    }
                }
            }
            qn = qn.parent(1);
        }
        return this.nxDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(DnsRecord rr, boolean checkSets, boolean checkMap) {
        ConcurrentMap current = (ConcurrentMap)this.records.get(rr.getName());
        if (current != null) {
            ConcurrentMap concurrentMap = current;
            synchronized (concurrentMap) {
                NavigableSet sets = (NavigableSet)current.get(rr.getType());
                sets.remove(rr);
                if (checkSets && sets.isEmpty()) {
                    current.remove(rr.getType());
                    if (checkMap && current.isEmpty()) {
                        this.records.remove(rr.getName());
                    }
                }
            }
        }
    }
}

