/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.zone;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.zone.Query;
import dorkbox.network.dns.zone.Zone;
import dorkbox.network.dns.zone.ZoneDatabaseKey;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class ZoneDatabase {
    protected Map<ZoneDatabaseKey, Zone> zones = new ConcurrentSkipListMap<ZoneDatabaseKey, Zone>();

    public void add(Zone zone) {
        this.zones.put(new ZoneDatabaseKey(zone), zone);
    }

    public Query prepare(Name name, int dnsClass) {
        ZoneDatabaseKey zk = new ZoneDatabaseKey(name, dnsClass);
        Zone found = this.zones.get(zk);
        if (found != null) {
            return new Query(name, name, dnsClass, found, this);
        }
        Name child = name;
        int size = this.zones.size();
        for (int i = 0; i < size; ++i) {
            Name p = child.parent(1);
            zk.name(p);
            found = this.zones.get(zk);
            if (found == null) {
                if (p.labels() <= 1) break;
            } else {
                return new Query(name, p, dnsClass, found, this);
            }
            child = p;
        }
        return null;
    }
}

