/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.zone;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.zone.Zone;

class ZoneDatabaseKey
implements Comparable<ZoneDatabaseKey> {
    Name name;
    int dnsclass;

    public ZoneDatabaseKey(Zone z) {
        this(z.name(), z.dnsClass());
    }

    public ZoneDatabaseKey(DnsRecord rr) {
        this(rr.getName(), rr.getDClass());
    }

    public ZoneDatabaseKey(Name name, int dnsclass) {
        this.name = name;
        this.dnsclass = dnsclass;
    }

    @Override
    public int compareTo(ZoneDatabaseKey o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        return this.hashCode() - o.hashCode();
    }

    public boolean equals(ZoneDatabaseKey other) {
        return this.dnsclass == other.dnsclass && this.name.equals(other.name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((ZoneDatabaseKey)other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dnsclass;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public Name name() {
        return this.name;
    }

    public void name(Name name) {
        this.name = name;
    }
}

